/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.elasticsearch.common.Strings;

@ScopeDeclaration(id=15, name="ServiceInstanceInventory")
@Stream(name="service_instance_inventory", scopeId=15, builder=Builder.class, processor=InventoryStreamProcessor.class)
public class ServiceInstanceInventory
extends RegisterSource {
    public static final String INDEX_NAME = "service_instance_inventory";
    public static final String NAME = "name";
    public static final String INSTANCE_UUID = "instance_uuid";
    public static final String SERVICE_ID = "service_id";
    private static final String IS_ADDRESS = "is_address";
    private static final String ADDRESS_ID = "address_id";
    public static final String PROPERTIES = "properties";
    private static final Gson GSON = new Gson();
    @Column(columnName="instance_uuid", matchQuery=true)
    private String instanceUUID = "";
    @Column(columnName="name")
    private String name = "";
    @Column(columnName="service_id")
    private int serviceId;
    @Column(columnName="is_address")
    private int isAddress;
    @Column(columnName="address_id")
    private int addressId;
    @Column(columnName="properties")
    private String prop;
    private JsonObject properties;

    public static String buildId(int serviceId, String uuid) {
        return serviceId + "_" + uuid + "_" + 0 + "_" + 0;
    }

    public static String buildId(int serviceId, int addressId) {
        return serviceId + "_" + 1 + "_" + addressId;
    }

    @Override
    public String id() {
        if (1 == this.isAddress) {
            return ServiceInstanceInventory.buildId(this.serviceId, this.addressId);
        }
        return ServiceInstanceInventory.buildId(this.serviceId, this.instanceUUID);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.serviceId;
        result = 31 * result + this.instanceUUID.hashCode();
        result = 31 * result + this.isAddress;
        result = 31 * result + this.addressId;
        return result;
    }

    public void setProperties(JsonObject properties) {
        this.properties = properties;
        if (properties != null && properties.keySet().size() > 0) {
            this.prop = properties.toString();
        }
    }

    private void setProp(String prop) {
        this.prop = prop;
        if (!Strings.isNullOrEmpty((String)prop)) {
            this.properties = (JsonObject)GSON.fromJson(prop, JsonObject.class);
        }
    }

    public boolean hasProperties() {
        return this.prop != null && this.prop.length() > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInstanceInventory source = (ServiceInstanceInventory)obj;
        if (this.serviceId != source.getServiceId()) {
            return false;
        }
        if (!this.instanceUUID.equals(source.getInstanceUUID())) {
            return false;
        }
        if (this.isAddress != source.getIsAddress()) {
            return false;
        }
        return this.addressId == source.getAddressId();
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataIntegers(this.getSequence());
        remoteBuilder.addDataIntegers(this.serviceId);
        remoteBuilder.addDataIntegers(this.isAddress);
        remoteBuilder.addDataIntegers(this.addressId);
        remoteBuilder.addDataLongs(this.getRegisterTime());
        remoteBuilder.addDataLongs(this.getHeartbeatTime());
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.name) ? "" : this.name);
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.instanceUUID) ? "" : this.instanceUUID);
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.prop) ? "" : this.prop);
        return remoteBuilder;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setSequence(remoteData.getDataIntegers(0));
        this.setServiceId(remoteData.getDataIntegers(1));
        this.setIsAddress(remoteData.getDataIntegers(2));
        this.setAddressId(remoteData.getDataIntegers(3));
        this.setRegisterTime(remoteData.getDataLongs(0));
        this.setHeartbeatTime(remoteData.getDataLongs(1));
        this.setName(remoteData.getDataStrings(0));
        this.setInstanceUUID(remoteData.getDataStrings(1));
        this.setProp(remoteData.getDataStrings(2));
    }

    @Override
    public int remoteHashCode() {
        return 0;
    }

    public void setInstanceUUID(String instanceUUID) {
        this.instanceUUID = instanceUUID;
    }

    public String getInstanceUUID() {
        return this.instanceUUID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setIsAddress(int isAddress) {
        this.isAddress = isAddress;
    }

    public int getIsAddress() {
        return this.isAddress;
    }

    public void setAddressId(int addressId) {
        this.addressId = addressId;
    }

    public int getAddressId() {
        return this.addressId;
    }

    private String getProp() {
        return this.prop;
    }

    public JsonObject getProperties() {
        return this.properties;
    }

    public static class PropertyUtil {
        public static final String OS_NAME = "os_name";
        public static final String HOST_NAME = "host_name";
        public static final String PROCESS_NO = "process_no";
        public static final String IPV4S = "ipv4s";
        public static final String LANGUAGE = "language";

        public static String ipv4sSerialize(List<String> ipv4) {
            Gson gson = new Gson();
            return gson.toJson(ipv4);
        }

        public static List<String> ipv4sDeserialize(String ipv4s) {
            Gson gson = new Gson();
            return (List)gson.fromJson(ipv4s, new TypeToken<List<String>>(){}.getType());
        }
    }

    public static class Builder
    implements StorageBuilder<ServiceInstanceInventory> {
        @Override
        public ServiceInstanceInventory map2Data(Map<String, Object> dbMap) {
            ServiceInstanceInventory inventory = new ServiceInstanceInventory();
            inventory.setSequence((Integer)dbMap.get("sequence"));
            inventory.setServiceId((Integer)dbMap.get(ServiceInstanceInventory.SERVICE_ID));
            inventory.setIsAddress((Integer)dbMap.get(ServiceInstanceInventory.IS_ADDRESS));
            inventory.setAddressId((Integer)dbMap.get(ServiceInstanceInventory.ADDRESS_ID));
            inventory.setRegisterTime((Long)dbMap.get("register_time"));
            inventory.setHeartbeatTime((Long)dbMap.get("heartbeat_time"));
            inventory.setName((String)dbMap.get(ServiceInstanceInventory.NAME));
            inventory.setInstanceUUID((String)dbMap.get(ServiceInstanceInventory.INSTANCE_UUID));
            inventory.setProp((String)dbMap.get(ServiceInstanceInventory.PROPERTIES));
            return inventory;
        }

        @Override
        public Map<String, Object> data2Map(ServiceInstanceInventory storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sequence", storageData.getSequence());
            map.put(ServiceInstanceInventory.SERVICE_ID, storageData.getServiceId());
            map.put(ServiceInstanceInventory.IS_ADDRESS, storageData.getIsAddress());
            map.put(ServiceInstanceInventory.ADDRESS_ID, storageData.getAddressId());
            map.put("register_time", storageData.getRegisterTime());
            map.put("heartbeat_time", storageData.getHeartbeatTime());
            map.put(ServiceInstanceInventory.NAME, storageData.getName());
            map.put(ServiceInstanceInventory.INSTANCE_UUID, storageData.getInstanceUUID());
            map.put(ServiceInstanceInventory.PROPERTIES, storageData.getProp());
            return map;
        }
    }
}

