/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register;

import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum NodeType {
    Unknown(0),
    Database(1),
    RPCFramework(2),
    Http(3),
    MQ(4),
    Cache(5),
    UNRECOGNIZED(-1);

    private final int value;

    private NodeType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static NodeType get(int value) {
        switch (value) {
            case 0: {
                return Unknown;
            }
            case 1: {
                return Database;
            }
            case 2: {
                return RPCFramework;
            }
            case 3: {
                return Http;
            }
            case 4: {
                return MQ;
            }
            case 5: {
                return Cache;
            }
            case -1: {
                return UNRECOGNIZED;
            }
        }
        throw new UnexpectedException("Unknown NodeType value");
    }

    public static NodeType fromSpanLayerValue(int spanLayerValue) {
        return NodeType.get(spanLayerValue);
    }
}

