/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.register.NodeType;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.elasticsearch.common.Strings;

@ScopeDeclaration(id=7, name="NetworkAddress")
@Stream(name="network_address_inventory", scopeId=7, builder=Builder.class, processor=InventoryStreamProcessor.class)
public class NetworkAddressInventory
extends RegisterSource {
    public static final String INDEX_NAME = "network_address_inventory";
    private static final String NAME = "name";
    private static final String NODE_TYPE = "node_type";
    @Column(columnName="name", matchQuery=true)
    private String name = "";
    @Column(columnName="node_type")
    private int nodeType;

    public void setNetworkAddressNodeType(NodeType nodeType) {
        this.nodeType = nodeType.value();
    }

    public NodeType getNetworkAddressNodeType() {
        return NodeType.get(this.nodeType);
    }

    public static String buildId(String networkAddress) {
        return networkAddress;
    }

    @Override
    public String id() {
        return NetworkAddressInventory.buildId(this.name);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkAddressInventory source = (NetworkAddressInventory)obj;
        return this.name.equals(source.getName());
    }

    public NetworkAddressInventory getClone() {
        NetworkAddressInventory inventory = new NetworkAddressInventory();
        inventory.setSequence(this.getSequence());
        inventory.setRegisterTime(this.getRegisterTime());
        inventory.setHeartbeatTime(this.getHeartbeatTime());
        inventory.setName(this.name);
        inventory.setNodeType(this.nodeType);
        return inventory;
    }

    @Override
    public boolean combine(RegisterSource registerSource) {
        boolean isCombine = super.combine(registerSource);
        NetworkAddressInventory inventory = (NetworkAddressInventory)registerSource;
        if (this.nodeType != inventory.nodeType) {
            this.setNodeType(inventory.nodeType);
            return true;
        }
        return isCombine;
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataIntegers(this.getSequence());
        remoteBuilder.addDataIntegers(this.getNodeType());
        remoteBuilder.addDataLongs(this.getRegisterTime());
        remoteBuilder.addDataLongs(this.getHeartbeatTime());
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.name) ? "" : this.name);
        return remoteBuilder;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setSequence(remoteData.getDataIntegers(0));
        this.setNodeType(remoteData.getDataIntegers(1));
        this.setRegisterTime(remoteData.getDataLongs(0));
        this.setHeartbeatTime(remoteData.getDataLongs(1));
        this.setName(remoteData.getDataStrings(0));
    }

    @Override
    public int remoteHashCode() {
        return 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    private int getNodeType() {
        return this.nodeType;
    }

    public static class Builder
    implements StorageBuilder<NetworkAddressInventory> {
        @Override
        public NetworkAddressInventory map2Data(Map<String, Object> dbMap) {
            NetworkAddressInventory inventory = new NetworkAddressInventory();
            inventory.setSequence((Integer)dbMap.get("sequence"));
            inventory.setName((String)dbMap.get(NetworkAddressInventory.NAME));
            inventory.setNodeType((Integer)dbMap.get(NetworkAddressInventory.NODE_TYPE));
            inventory.setRegisterTime((Long)dbMap.get("register_time"));
            inventory.setHeartbeatTime((Long)dbMap.get("heartbeat_time"));
            return inventory;
        }

        @Override
        public Map<String, Object> data2Map(NetworkAddressInventory storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sequence", storageData.getSequence());
            map.put(NetworkAddressInventory.NAME, storageData.getName());
            map.put(NetworkAddressInventory.NODE_TYPE, storageData.getNodeType());
            map.put("register_time", storageData.getRegisterTime());
            map.put("heartbeat_time", storageData.getHeartbeatTime());
            return map;
        }
    }
}

