/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.elasticsearch.common.Strings;

@ScopeDeclaration(id=16, name="EndpointInventory")
@Stream(name="endpoint_inventory", scopeId=16, builder=Builder.class, processor=InventoryStreamProcessor.class)
public class EndpointInventory
extends RegisterSource {
    public static final String INDEX_NAME = "endpoint_inventory";
    public static final String SERVICE_ID = "service_id";
    public static final String NAME = "name";
    public static final String DETECT_POINT = "detect_point";
    @Column(columnName="service_id")
    private int serviceId;
    @Column(columnName="name", matchQuery=true)
    private String name = "";
    @Column(columnName="detect_point")
    private int detectPoint;

    public static String buildId(int serviceId, String endpointName, int detectPoint) {
        return serviceId + "_" + endpointName + "_" + detectPoint;
    }

    @Override
    public String id() {
        return EndpointInventory.buildId(this.serviceId, this.name, this.detectPoint);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.serviceId;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.detectPoint;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointInventory source = (EndpointInventory)obj;
        if (this.serviceId != source.getServiceId()) {
            return false;
        }
        if (!this.name.equals(source.getName())) {
            return false;
        }
        return this.detectPoint == source.getDetectPoint();
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataIntegers(this.getSequence());
        remoteBuilder.addDataIntegers(this.serviceId);
        remoteBuilder.addDataIntegers(this.detectPoint);
        remoteBuilder.addDataLongs(this.getRegisterTime());
        remoteBuilder.addDataLongs(this.getHeartbeatTime());
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.name) ? "" : this.name);
        return remoteBuilder;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setSequence(remoteData.getDataIntegers(0));
        this.setServiceId(remoteData.getDataIntegers(1));
        this.setDetectPoint(remoteData.getDataIntegers(2));
        this.setRegisterTime(remoteData.getDataLongs(0));
        this.setHeartbeatTime(remoteData.getDataLongs(1));
        this.setName(remoteData.getDataStrings(0));
    }

    @Override
    public int remoteHashCode() {
        return 0;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDetectPoint(int detectPoint) {
        this.detectPoint = detectPoint;
    }

    public int getDetectPoint() {
        return this.detectPoint;
    }

    public static class Builder
    implements StorageBuilder<EndpointInventory> {
        @Override
        public EndpointInventory map2Data(Map<String, Object> dbMap) {
            EndpointInventory inventory = new EndpointInventory();
            inventory.setSequence((Integer)dbMap.get("sequence"));
            inventory.setServiceId((Integer)dbMap.get(EndpointInventory.SERVICE_ID));
            inventory.setName((String)dbMap.get(EndpointInventory.NAME));
            inventory.setDetectPoint((Integer)dbMap.get(EndpointInventory.DETECT_POINT));
            inventory.setRegisterTime((Long)dbMap.get("register_time"));
            inventory.setHeartbeatTime((Long)dbMap.get("heartbeat_time"));
            return inventory;
        }

        @Override
        public Map<String, Object> data2Map(EndpointInventory storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sequence", storageData.getSequence());
            map.put(EndpointInventory.SERVICE_ID, storageData.getServiceId());
            map.put(EndpointInventory.NAME, storageData.getName());
            map.put(EndpointInventory.DETECT_POINT, storageData.getDetectPoint());
            map.put("register_time", storageData.getRegisterTime());
            map.put("heartbeat_time", storageData.getHeartbeatTime());
            return map;
        }
    }
}

