/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.entity;

import java.util.ArrayList;
import java.util.List;

public class Thermodynamic {
    private final List<List<Long>> nodes = new ArrayList<List<Long>>();
    private int axisYStep;

    public void fromMatrixData(List<List<Long>> thermodynamicValueMatrix, int numOfSteps) {
        thermodynamicValueMatrix.forEach(columnOfThermodynamic -> {
            if (columnOfThermodynamic.size() == 0 && numOfSteps > 0) {
                for (int i = 0; i < numOfSteps; ++i) {
                    columnOfThermodynamic.add(0L);
                }
            }
        });
        for (int colNum = 0; colNum < thermodynamicValueMatrix.size(); ++colNum) {
            List<Long> column = thermodynamicValueMatrix.get(colNum);
            for (int rowNum = 0; rowNum < column.size(); ++rowNum) {
                Long value = column.get(rowNum);
                this.setNodeValue(colNum, rowNum, value);
            }
        }
    }

    private void setNodeValue(int columnNum, int rowNum, Long value) {
        ArrayList<Long> element = new ArrayList<Long>(3);
        element.add(Long.valueOf(columnNum));
        element.add(Long.valueOf(rowNum));
        element.add(value);
        this.nodes.add(element);
    }

    public List<List<Long>> getNodes() {
        return this.nodes;
    }

    public int getAxisYStep() {
        return this.axisYStep;
    }

    public void setAxisYStep(int axisYStep) {
        this.axisYStep = axisYStep;
    }
}

