/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.entity;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.source.DetectPoint;

public class Call {
    private Integer source;
    private Integer target;
    private List<String> sourceComponents = new ArrayList<String>();
    private List<String> targetComponents = new ArrayList<String>();
    private String id;
    private List<DetectPoint> detectPoints = new ArrayList<DetectPoint>();
    private List<Integer> sourceComponentIDs;
    private List<Integer> targetComponentIDs;

    public void setSource(int source) {
        this.source = source;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public void addSourceComponentId(int componentId) {
        this.sourceComponentIDs.add(componentId);
    }

    public void addTargetComponentId(int componentId) {
        this.targetComponentIDs.add(componentId);
    }

    public void addSourceComponent(String component) {
        if (!this.sourceComponents.contains(component)) {
            this.sourceComponents.add(component);
        }
    }

    public void addTargetComponent(String component) {
        if (!this.targetComponents.contains(component)) {
            this.targetComponents.add(component);
        }
    }

    public void addDetectPoint(DetectPoint point) {
        if (!this.detectPoints.contains((Object)point)) {
            this.detectPoints.add(point);
        }
    }

    public Integer getSource() {
        return this.source;
    }

    public Integer getTarget() {
        return this.target;
    }

    public List<String> getSourceComponents() {
        return this.sourceComponents;
    }

    public List<String> getTargetComponents() {
        return this.targetComponents;
    }

    public String getId() {
        return this.id;
    }

    public List<DetectPoint> getDetectPoints() {
        return this.detectPoints;
    }

    public List<Integer> getSourceComponentIDs() {
        return this.sourceComponentIDs;
    }

    public List<Integer> getTargetComponentIDs() {
        return this.targetComponentIDs;
    }

    public void setSourceComponents(List<String> sourceComponents) {
        this.sourceComponents = sourceComponents;
    }

    public void setTargetComponents(List<String> targetComponents) {
        this.targetComponents = targetComponents;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDetectPoints(List<DetectPoint> detectPoints) {
        this.detectPoints = detectPoints;
    }

    public void setSourceComponentIDs(List<Integer> sourceComponentIDs) {
        this.sourceComponentIDs = sourceComponentIDs;
    }

    public void setTargetComponentIDs(List<Integer> targetComponentIDs) {
        this.targetComponentIDs = targetComponentIDs;
    }

    public static class CallDetail {
        private String id;
        private Integer source;
        private Integer target;
        private DetectPoint detectPoint;
        private Integer componentId;

        public void generateID() {
            this.id = this.source + "_" + this.target;
        }

        public void setSource(Integer source) {
            this.source = source;
        }

        public void setTarget(Integer target) {
            this.target = target;
        }

        public void setDetectPoint(DetectPoint detectPoint) {
            this.detectPoint = detectPoint;
        }

        public void setComponentId(Integer componentId) {
            this.componentId = componentId;
        }

        public String getId() {
            return this.id;
        }

        public Integer getSource() {
            return this.source;
        }

        public Integer getTarget() {
            return this.target;
        }

        public DetectPoint getDetectPoint() {
            return this.detectPoint;
        }

        public Integer getComponentId() {
            return this.componentId;
        }

        private void setId(String id) {
            this.id = id;
        }
    }
}

