/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.network.language.agent.SpanObject;
import org.apache.skywalking.apm.network.language.agent.TraceSegmentObject;
import org.apache.skywalking.apm.network.language.agent.UniqueId;
import org.apache.skywalking.apm.network.language.agent.v2.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v2.SpanObjectV2;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.entity.KeyValue;
import org.apache.skywalking.oap.server.core.query.entity.LogEntity;
import org.apache.skywalking.oap.server.core.query.entity.Pagination;
import org.apache.skywalking.oap.server.core.query.entity.QueryOrder;
import org.apache.skywalking.oap.server.core.query.entity.Ref;
import org.apache.skywalking.oap.server.core.query.entity.RefType;
import org.apache.skywalking.oap.server.core.query.entity.Span;
import org.apache.skywalking.oap.server.core.query.entity.Trace;
import org.apache.skywalking.oap.server.core.query.entity.TraceBrief;
import org.apache.skywalking.oap.server.core.query.entity.TraceState;
import org.apache.skywalking.oap.server.core.register.EndpointInventory;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class TraceQueryService
implements Service {
    private final ModuleManager moduleManager;
    private ITraceQueryDAO traceQueryDAO;
    private ServiceInventoryCache serviceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;
    private NetworkAddressInventoryCache networkAddressInventoryCache;
    private IComponentLibraryCatalogService componentLibraryCatalogService;

    public TraceQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private ITraceQueryDAO getTraceQueryDAO() {
        if (this.traceQueryDAO == null) {
            this.traceQueryDAO = (ITraceQueryDAO)this.moduleManager.find("storage").provider().getService(ITraceQueryDAO.class);
        }
        return this.traceQueryDAO;
    }

    private ServiceInventoryCache getServiceInventoryCache() {
        if (this.serviceInventoryCache == null) {
            this.serviceInventoryCache = (ServiceInventoryCache)this.moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        }
        return this.serviceInventoryCache;
    }

    private EndpointInventoryCache getEndpointInventoryCache() {
        if (this.endpointInventoryCache == null) {
            this.endpointInventoryCache = (EndpointInventoryCache)this.moduleManager.find("core").provider().getService(EndpointInventoryCache.class);
        }
        return this.endpointInventoryCache;
    }

    private NetworkAddressInventoryCache getNetworkAddressInventoryCache() {
        if (this.networkAddressInventoryCache == null) {
            this.networkAddressInventoryCache = (NetworkAddressInventoryCache)this.moduleManager.find("core").provider().getService(NetworkAddressInventoryCache.class);
        }
        return this.networkAddressInventoryCache;
    }

    private IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    public TraceBrief queryBasicTraces(int serviceId, int serviceInstanceId, int endpointId, String traceId, String endpointName, int minTraceDuration, int maxTraceDuration, TraceState traceState, QueryOrder queryOrder, Pagination paging, long startTB, long endTB) throws IOException {
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(paging);
        return this.getTraceQueryDAO().queryBasicTraces(startTB, endTB, minTraceDuration, maxTraceDuration, endpointName, serviceId, serviceInstanceId, endpointId, traceId, page.getLimit(), page.getFrom(), traceState, queryOrder);
    }

    public Trace queryTrace(String traceId) throws IOException {
        List<Span> rootSpans;
        Trace trace = new Trace();
        List<SegmentRecord> segmentRecords = this.getTraceQueryDAO().queryByTraceId(traceId);
        if (segmentRecords.isEmpty()) {
            trace.getSpans().addAll(this.getTraceQueryDAO().doFlexibleTraceQuery(traceId));
        } else {
            for (SegmentRecord segment : segmentRecords) {
                SegmentObject segmentObject;
                if (!Objects.nonNull(segment)) continue;
                if (segment.getVersion() == 2) {
                    segmentObject = SegmentObject.parseFrom((byte[])segment.getDataBinary());
                    trace.getSpans().addAll(this.buildSpanV2List(traceId, segment.getSegmentId(), segment.getServiceId(), segmentObject.getSpansList()));
                    continue;
                }
                segmentObject = TraceSegmentObject.parseFrom((byte[])segment.getDataBinary());
                trace.getSpans().addAll(this.buildSpanList(traceId, segment.getSegmentId(), segment.getServiceId(), segmentObject.getSpansList()));
            }
        }
        LinkedList sortedSpans = new LinkedList();
        if (CollectionUtils.isNotEmpty(trace.getSpans()) && CollectionUtils.isNotEmpty(rootSpans = this.findRoot(trace.getSpans()))) {
            rootSpans.forEach(span -> {
                ArrayList<Span> childrenSpan = new ArrayList<Span>();
                childrenSpan.add((Span)span);
                this.findChildren(trace.getSpans(), (Span)span, (List<Span>)childrenSpan);
                sortedSpans.addAll(childrenSpan);
            });
        }
        trace.getSpans().clear();
        trace.getSpans().addAll(sortedSpans);
        return trace;
    }

    private List<Span> buildSpanV2List(String traceId, String segmentId, int serviceId, List<SpanObjectV2> spanObjects) {
        ArrayList<Span> spans = new ArrayList<Span>();
        spanObjects.forEach(spanObject -> {
            Span span = new Span();
            span.setTraceId(traceId);
            span.setSegmentId(segmentId);
            span.setSpanId(spanObject.getSpanId());
            span.setParentSpanId(spanObject.getParentSpanId());
            span.setStartTime(spanObject.getStartTime());
            span.setEndTime(spanObject.getEndTime());
            span.setError(spanObject.getIsError());
            span.setLayer(spanObject.getSpanLayer().name());
            span.setType(spanObject.getSpanType().name());
            String segmentSpanId = segmentId + "S" + String.valueOf(spanObject.getSpanId());
            span.setSegmentSpanId(segmentSpanId);
            String segmentParentSpanId = segmentId + "S" + String.valueOf(spanObject.getParentSpanId());
            span.setSegmentParentSpanId(segmentParentSpanId);
            if (spanObject.getPeerId() == 0) {
                span.setPeer(spanObject.getPeer());
            } else {
                span.setPeer(this.getNetworkAddressInventoryCache().get(spanObject.getPeerId()).getName());
            }
            String endpointName = spanObject.getOperationName();
            if (spanObject.getOperationNameId() != 0) {
                EndpointInventory endpointInventory = this.getEndpointInventoryCache().get(spanObject.getOperationNameId());
                endpointName = Objects.nonNull(endpointInventory) ? endpointInventory.getName() : "";
            }
            span.setEndpointName(endpointName);
            String serviceCode = this.getServiceInventoryCache().get(serviceId).getName();
            span.setServiceCode(serviceCode);
            if (spanObject.getComponentId() == 0) {
                span.setComponent(spanObject.getComponent());
            } else {
                span.setComponent(this.getComponentLibraryCatalogService().getComponentName(spanObject.getComponentId()));
            }
            spanObject.getRefsList().forEach(reference -> {
                Ref ref = new Ref();
                ref.setTraceId(traceId);
                switch (reference.getRefType()) {
                    case CrossThread: {
                        ref.setType(RefType.CROSS_THREAD);
                        break;
                    }
                    case CrossProcess: {
                        ref.setType(RefType.CROSS_PROCESS);
                    }
                }
                ref.setParentSpanId(reference.getParentSpanId());
                UniqueId uniqueId = reference.getParentTraceSegmentId();
                StringBuilder segmentIdBuilder = new StringBuilder();
                for (int i = 0; i < uniqueId.getIdPartsList().size(); ++i) {
                    if (i == 0) {
                        segmentIdBuilder.append(String.valueOf(uniqueId.getIdPartsList().get(i)));
                        continue;
                    }
                    segmentIdBuilder.append(".").append(String.valueOf(uniqueId.getIdPartsList().get(i)));
                }
                ref.setParentSegmentId(segmentIdBuilder.toString());
                span.setSegmentParentSpanId(ref.getParentSegmentId() + "S" + String.valueOf(ref.getParentSpanId()));
                span.getRefs().add(ref);
            });
            spanObject.getTagsList().forEach(tag -> {
                KeyValue keyValue = new KeyValue();
                keyValue.setKey(tag.getKey());
                keyValue.setValue(tag.getValue());
                span.getTags().add(keyValue);
            });
            spanObject.getLogsList().forEach(log -> {
                LogEntity logEntity = new LogEntity();
                logEntity.setTime(log.getTime());
                log.getDataList().forEach(data -> {
                    KeyValue keyValue = new KeyValue();
                    keyValue.setKey(data.getKey());
                    keyValue.setValue(data.getValue());
                    logEntity.getData().add(keyValue);
                });
                span.getLogs().add(logEntity);
            });
            spans.add(span);
        });
        return spans;
    }

    private List<Span> buildSpanList(String traceId, String segmentId, int serviceId, List<SpanObject> spanObjects) {
        ArrayList<Span> spans = new ArrayList<Span>();
        spanObjects.forEach(spanObject -> {
            Span span = new Span();
            span.setTraceId(traceId);
            span.setSegmentId(segmentId);
            span.setSpanId(spanObject.getSpanId());
            span.setParentSpanId(spanObject.getParentSpanId());
            span.setStartTime(spanObject.getStartTime());
            span.setEndTime(spanObject.getEndTime());
            span.setError(spanObject.getIsError());
            span.setLayer(spanObject.getSpanLayer().name());
            span.setType(spanObject.getSpanType().name());
            String segmentSpanId = segmentId + "S" + String.valueOf(spanObject.getSpanId());
            span.setSegmentSpanId(segmentSpanId);
            String segmentParentSpanId = segmentId + "S" + String.valueOf(spanObject.getParentSpanId());
            span.setSegmentParentSpanId(segmentParentSpanId);
            if (spanObject.getPeerId() == 0) {
                span.setPeer(spanObject.getPeer());
            } else {
                span.setPeer(this.getNetworkAddressInventoryCache().get(spanObject.getPeerId()).getName());
            }
            String endpointName = spanObject.getOperationName();
            if (spanObject.getOperationNameId() != 0) {
                EndpointInventory endpointInventory = this.getEndpointInventoryCache().get(spanObject.getOperationNameId());
                endpointName = Objects.nonNull(endpointInventory) ? endpointInventory.getName() : "";
            }
            span.setEndpointName(endpointName);
            String serviceCode = this.getServiceInventoryCache().get(serviceId).getName();
            span.setServiceCode(serviceCode);
            if (spanObject.getComponentId() == 0) {
                span.setComponent(spanObject.getComponent());
            } else {
                span.setComponent(this.getComponentLibraryCatalogService().getComponentName(spanObject.getComponentId()));
            }
            spanObject.getRefsList().forEach(reference -> {
                Ref ref = new Ref();
                ref.setTraceId(traceId);
                switch (reference.getRefType()) {
                    case CrossThread: {
                        ref.setType(RefType.CROSS_THREAD);
                        break;
                    }
                    case CrossProcess: {
                        ref.setType(RefType.CROSS_PROCESS);
                    }
                }
                ref.setParentSpanId(reference.getParentSpanId());
                UniqueId uniqueId = reference.getParentTraceSegmentId();
                StringBuilder segmentIdBuilder = new StringBuilder();
                for (int i = 0; i < uniqueId.getIdPartsList().size(); ++i) {
                    if (i == 0) {
                        segmentIdBuilder.append(String.valueOf(uniqueId.getIdPartsList().get(i)));
                        continue;
                    }
                    segmentIdBuilder.append(".").append(String.valueOf(uniqueId.getIdPartsList().get(i)));
                }
                ref.setParentSegmentId(segmentIdBuilder.toString());
                span.setSegmentParentSpanId(ref.getParentSegmentId() + "S" + String.valueOf(ref.getParentSpanId()));
                span.getRefs().add(ref);
            });
            spanObject.getTagsList().forEach(tag -> {
                KeyValue keyValue = new KeyValue();
                keyValue.setKey(tag.getKey());
                keyValue.setValue(tag.getValue());
                span.getTags().add(keyValue);
            });
            spanObject.getLogsList().forEach(log -> {
                LogEntity logEntity = new LogEntity();
                logEntity.setTime(log.getTime());
                log.getDataList().forEach(data -> {
                    KeyValue keyValue = new KeyValue();
                    keyValue.setKey(data.getKey());
                    keyValue.setValue(data.getValue());
                    logEntity.getData().add(keyValue);
                });
                span.getLogs().add(logEntity);
            });
            spans.add(span);
        });
        return spans;
    }

    private List<Span> findRoot(List<Span> spans) {
        ArrayList<Span> rootSpans = new ArrayList<Span>();
        spans.forEach(span -> {
            String segmentParentSpanId = span.getSegmentParentSpanId();
            boolean hasParent = false;
            for (Span subSpan : spans) {
                if (!segmentParentSpanId.equals(subSpan.getSegmentSpanId())) continue;
                hasParent = true;
            }
            if (!hasParent) {
                span.setRoot(true);
                rootSpans.add((Span)span);
            }
        });
        return rootSpans;
    }

    private void findChildren(List<Span> spans, Span parentSpan, List<Span> childrenSpan) {
        spans.forEach(span -> {
            if (span.getSegmentParentSpanId().equals(parentSpan.getSegmentSpanId())) {
                childrenSpan.add((Span)span);
                this.findChildren(spans, (Span)span, childrenSpan);
            }
        });
    }
}

