/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.TopologyBuilder;
import org.apache.skywalking.oap.server.core.query.entity.Call;
import org.apache.skywalking.oap.server.core.query.entity.Node;
import org.apache.skywalking.oap.server.core.query.entity.Topology;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.elasticsearch.common.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyQueryService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(TopologyQueryService.class);
    private final ModuleManager moduleManager;
    private ITopologyQueryDAO topologyQueryDAO;
    private IMetadataQueryDAO metadataQueryDAO;
    private EndpointInventoryCache endpointInventoryCache;
    private IComponentLibraryCatalogService componentLibraryCatalogService;

    public TopologyQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    private ITopologyQueryDAO getTopologyQueryDAO() {
        if (this.topologyQueryDAO == null) {
            this.topologyQueryDAO = (ITopologyQueryDAO)this.moduleManager.find("storage").provider().getService(ITopologyQueryDAO.class);
        }
        return this.topologyQueryDAO;
    }

    private IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    private EndpointInventoryCache getEndpointInventoryCache() {
        if (this.endpointInventoryCache == null) {
            this.endpointInventoryCache = (EndpointInventoryCache)this.moduleManager.find("core").provider().getService(EndpointInventoryCache.class);
        }
        return this.endpointInventoryCache;
    }

    public Topology getGlobalTopology(Downsampling downsampling, long startTB, long endTB, long startTimestamp, long endTimestamp) throws IOException {
        logger.debug("Downsampling: {}, startTimeBucket: {}, endTimeBucket: {}", new Object[]{downsampling, startTB, endTB});
        List<Call.CallDetail> serviceRelationServerCalls = this.getTopologyQueryDAO().loadServerSideServiceRelations(downsampling, startTB, endTB);
        List<Call.CallDetail> serviceRelationClientCalls = this.getTopologyQueryDAO().loadClientSideServiceRelations(downsampling, startTB, endTB);
        TopologyBuilder builder = new TopologyBuilder(this.moduleManager);
        Topology topology = builder.build(serviceRelationClientCalls, serviceRelationServerCalls);
        return topology;
    }

    public Topology getServiceTopology(Downsampling downsampling, long startTB, long endTB, int serviceId) throws IOException {
        ArrayList<Integer> serviceIds = new ArrayList<Integer>();
        serviceIds.add(serviceId);
        List<Call.CallDetail> serviceRelationClientCalls = this.getTopologyQueryDAO().loadSpecifiedClientSideServiceRelations(downsampling, startTB, endTB, serviceIds);
        List<Call.CallDetail> serviceRelationServerCalls = this.getTopologyQueryDAO().loadSpecifiedServerSideServiceRelations(downsampling, startTB, endTB, serviceIds);
        TopologyBuilder builder = new TopologyBuilder(this.moduleManager);
        Topology topology = builder.build(serviceRelationClientCalls, serviceRelationServerCalls);
        ArrayList<Integer> sourceServiceIds = new ArrayList<Integer>();
        serviceRelationClientCalls.forEach(call -> sourceServiceIds.add(call.getSource()));
        if (CollectionUtils.isNotEmpty(sourceServiceIds)) {
            List<Call.CallDetail> sourceCalls = this.getTopologyQueryDAO().loadSpecifiedServerSideServiceRelations(downsampling, startTB, endTB, sourceServiceIds);
            topology.getNodes().forEach(node -> {
                if (Strings.isNullOrEmpty((String)node.getType())) {
                    for (Call.CallDetail call : sourceCalls) {
                        if (node.getId() != call.getTarget().intValue()) continue;
                        node.setType(this.getComponentLibraryCatalogService().getComponentName(call.getComponentId()));
                        break;
                    }
                }
            });
        }
        return topology;
    }

    public Topology getEndpointTopology(Downsampling downsampling, long startTB, long endTB, int endpointId) throws IOException {
        List<Call.CallDetail> serverSideCalls = this.getTopologyQueryDAO().loadSpecifiedDestOfServerSideEndpointRelations(downsampling, startTB, endTB, endpointId);
        Topology topology = new Topology();
        serverSideCalls.forEach(callDetail -> {
            Call call = new Call();
            call.setId(callDetail.getId());
            call.setSource(callDetail.getSource());
            call.setTarget(callDetail.getTarget());
            call.addDetectPoint(DetectPoint.SERVER);
            topology.getCalls().add(call);
        });
        HashSet nodeIds = new HashSet();
        serverSideCalls.forEach(call -> {
            if (!nodeIds.contains(call.getSource())) {
                topology.getNodes().add(this.buildEndpointNode(call.getSource()));
                nodeIds.add(call.getSource());
            }
            if (!nodeIds.contains(call.getTarget())) {
                topology.getNodes().add(this.buildEndpointNode(call.getTarget()));
                nodeIds.add(call.getTarget());
            }
        });
        return topology;
    }

    private Node buildEndpointNode(int endpointId) {
        Node node = new Node();
        node.setId(endpointId);
        node.setName(this.getEndpointInventoryCache().get(endpointId).getName());
        node.setType("");
        node.setReal(true);
        return node;
    }
}

