/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.entity.Call;
import org.apache.skywalking.oap.server.core.query.entity.Node;
import org.apache.skywalking.oap.server.core.query.entity.Topology;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopologyBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TopologyBuilder.class);
    private final ServiceInventoryCache serviceInventoryCache;
    private final IComponentLibraryCatalogService componentLibraryCatalogService;

    TopologyBuilder(ModuleManager moduleManager) {
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.componentLibraryCatalogService = (IComponentLibraryCatalogService)moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
    }

    Topology build(List<Call.CallDetail> serviceRelationClientCalls, List<Call.CallDetail> serviceRelationServerCalls) {
        Call call;
        String callId;
        ServiceInventory target;
        ServiceInventory source;
        this.filterZeroSourceOrTargetReference(serviceRelationClientCalls);
        this.filterZeroSourceOrTargetReference(serviceRelationServerCalls);
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        LinkedList<Call> calls = new LinkedList<Call>();
        HashMap<String, Call> callMap = new HashMap<String, Call>();
        for (Call.CallDetail clientCall : serviceRelationClientCalls) {
            source = this.serviceInventoryCache.get(clientCall.getSource());
            target = this.serviceInventoryCache.get(clientCall.getTarget());
            if (target.getMappingServiceId() != 0) continue;
            if (!nodes.containsKey(source.getSequence())) {
                nodes.put(source.getSequence(), this.buildNode(source));
            }
            if (!nodes.containsKey(target.getSequence())) {
                nodes.put(target.getSequence(), this.buildNode(target));
                if (BooleanUtils.valueToBoolean((int)target.getIsAddress())) {
                    ((Node)nodes.get(target.getSequence())).setType(this.componentLibraryCatalogService.getServerNameBasedOnComponent(clientCall.getComponentId()));
                }
            }
            if (!callMap.containsKey(callId = source.getSequence() + "_" + target.getSequence())) {
                call = new Call();
                callMap.put(callId, call);
                call.setSource(clientCall.getSource());
                call.setTarget(clientCall.getTarget());
                call.setId(clientCall.getId());
                call.addDetectPoint(DetectPoint.CLIENT);
                call.addSourceComponent(this.componentLibraryCatalogService.getComponentName(clientCall.getComponentId()));
                calls.add(call);
                continue;
            }
            call = (Call)callMap.get(callId);
            call.addDetectPoint(DetectPoint.CLIENT);
            call.addSourceComponent(this.componentLibraryCatalogService.getComponentName(clientCall.getComponentId()));
        }
        for (Call.CallDetail serverCall : serviceRelationServerCalls) {
            source = this.serviceInventoryCache.get(serverCall.getSource());
            target = this.serviceInventoryCache.get(serverCall.getTarget());
            if (source.getSequence() == 1 && !nodes.containsKey(source.getSequence())) {
                Node visualUserNode = new Node();
                visualUserNode.setId(source.getSequence());
                visualUserNode.setName("User");
                visualUserNode.setType("User".toUpperCase());
                visualUserNode.setReal(false);
                nodes.put(source.getSequence(), visualUserNode);
            }
            if (BooleanUtils.valueToBoolean((int)source.getIsAddress()) && !nodes.containsKey(source.getSequence())) {
                Node conjecturalNode = new Node();
                conjecturalNode.setId(source.getSequence());
                conjecturalNode.setName(source.getName());
                conjecturalNode.setType(this.componentLibraryCatalogService.getServerNameBasedOnComponent(serverCall.getComponentId()));
                conjecturalNode.setReal(true);
                nodes.put(source.getSequence(), conjecturalNode);
            }
            if (!callMap.containsKey(callId = source.getSequence() + "_" + target.getSequence())) {
                call = new Call();
                callMap.put(callId, call);
                call.setSource(serverCall.getSource());
                call.setTarget(serverCall.getTarget());
                call.setId(serverCall.getId());
                call.addDetectPoint(DetectPoint.SERVER);
                call.addTargetComponent(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
                calls.add(call);
            } else {
                call = (Call)callMap.get(callId);
                call.addDetectPoint(DetectPoint.SERVER);
                call.addTargetComponent(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
            }
            if (!nodes.containsKey(source.getSequence())) {
                nodes.put(source.getSequence(), this.buildNode(source));
            }
            if (!nodes.containsKey(target.getSequence())) {
                nodes.put(target.getSequence(), this.buildNode(target));
            }
            if (!nodes.containsKey(target.getSequence())) continue;
            ((Node)nodes.get(target.getSequence())).setType(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
        }
        Topology topology = new Topology();
        topology.getCalls().addAll(calls);
        topology.getNodes().addAll(nodes.values());
        return topology;
    }

    private Node buildNode(ServiceInventory serviceInventory) {
        Node serviceNode = new Node();
        serviceNode.setId(serviceInventory.getSequence());
        serviceNode.setName(serviceInventory.getName());
        if (BooleanUtils.valueToBoolean((int)serviceInventory.getIsAddress())) {
            serviceNode.setReal(false);
        } else {
            serviceNode.setReal(true);
        }
        return serviceNode;
    }

    private void filterZeroSourceOrTargetReference(List<Call.CallDetail> serviceRelationClientCalls) {
        for (int i = serviceRelationClientCalls.size() - 1; i >= 0; --i) {
            Call.CallDetail call = serviceRelationClientCalls.get(i);
            if (call.getSource() != 0 && call.getTarget() != 0) continue;
            serviceRelationClientCalls.remove(i);
        }
    }
}

