/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.query.DurationPoint;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.entity.IntValues;
import org.apache.skywalking.oap.server.core.query.entity.Thermodynamic;
import org.apache.skywalking.oap.server.core.query.sql.KeyValues;
import org.apache.skywalking.oap.server.core.query.sql.Where;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnIds;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class MetricQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IMetricsQueryDAO metricQueryDAO;

    public MetricQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IMetricsQueryDAO getMetricQueryDAO() {
        if (this.metricQueryDAO == null) {
            this.metricQueryDAO = (IMetricsQueryDAO)this.moduleManager.find("storage").provider().getService(IMetricsQueryDAO.class);
        }
        return this.metricQueryDAO;
    }

    public IntValues getValues(String indName, List<String> ids, Downsampling downsampling, long startTB, long endTB) throws IOException {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("IDs can't be null");
        }
        Where where = new Where();
        KeyValues intKeyValues = new KeyValues();
        intKeyValues.setKey("entity_id");
        where.getKeyValues().add(intKeyValues);
        ids.forEach(intKeyValues.getValues()::add);
        return this.getMetricQueryDAO().getValues(indName, downsampling, startTB, endTB, where, ValueColumnIds.INSTANCE.getValueCName(indName), ValueColumnIds.INSTANCE.getValueFunction(indName));
    }

    public IntValues getLinearIntValues(String indName, String id, Downsampling downsampling, long startTB, long endTB) throws IOException, ParseException {
        List<DurationPoint> durationPoints = DurationUtils.INSTANCE.getDurationPoints(downsampling, startTB, endTB);
        ArrayList<String> ids = new ArrayList<String>();
        if (StringUtil.isEmpty((String)id)) {
            durationPoints.forEach(durationPoint -> ids.add(String.valueOf(durationPoint.getPoint())));
        } else {
            durationPoints.forEach(durationPoint -> ids.add(durationPoint.getPoint() + "_" + id));
        }
        return this.getMetricQueryDAO().getLinearIntValues(indName, downsampling, ids, ValueColumnIds.INSTANCE.getValueCName(indName));
    }

    public Thermodynamic getThermodynamic(String indName, String id, Downsampling downsampling, long startTB, long endTB) throws IOException, ParseException {
        List<DurationPoint> durationPoints = DurationUtils.INSTANCE.getDurationPoints(downsampling, startTB, endTB);
        ArrayList<String> ids = new ArrayList<String>();
        durationPoints.forEach(durationPoint -> {
            if (id == null) {
                ids.add(String.valueOf(durationPoint.getPoint()));
            } else {
                ids.add(durationPoint.getPoint() + "_" + id);
            }
        });
        return this.getMetricQueryDAO().getThermodynamic(indName, downsampling, ids, ValueColumnIds.INSTANCE.getValueCName(indName));
    }
}

