/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.query.entity.ClusterBrief;
import org.apache.skywalking.oap.server.core.query.entity.Database;
import org.apache.skywalking.oap.server.core.query.entity.Endpoint;
import org.apache.skywalking.oap.server.core.query.entity.EndpointInfo;
import org.apache.skywalking.oap.server.core.query.entity.Service;
import org.apache.skywalking.oap.server.core.query.entity.ServiceInstance;
import org.apache.skywalking.oap.server.core.register.EndpointInventory;
import org.apache.skywalking.oap.server.core.register.NodeType;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetadataQueryService
implements org.apache.skywalking.oap.server.library.module.Service {
    private final ModuleManager moduleManager;
    private IMetadataQueryDAO metadataQueryDAO;
    private ServiceInventoryCache serviceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;

    public MetadataQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    private ServiceInventoryCache getServiceInventoryCache() {
        if (this.serviceInventoryCache == null) {
            this.serviceInventoryCache = (ServiceInventoryCache)this.moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        }
        return this.serviceInventoryCache;
    }

    private EndpointInventoryCache getEndpointInventoryCache() {
        if (this.endpointInventoryCache == null) {
            this.endpointInventoryCache = (EndpointInventoryCache)this.moduleManager.find("core").provider().getService(EndpointInventoryCache.class);
        }
        return this.endpointInventoryCache;
    }

    public ClusterBrief getGlobalBrief(long startTimestamp, long endTimestamp) throws IOException {
        ClusterBrief clusterBrief = new ClusterBrief();
        clusterBrief.setNumOfService(this.getMetadataQueryDAO().numOfService(startTimestamp, endTimestamp));
        clusterBrief.setNumOfEndpoint(this.getMetadataQueryDAO().numOfEndpoint(startTimestamp, endTimestamp));
        clusterBrief.setNumOfDatabase(this.getMetadataQueryDAO().numOfConjectural(startTimestamp, endTimestamp, NodeType.Database.value()));
        clusterBrief.setNumOfCache(this.getMetadataQueryDAO().numOfConjectural(startTimestamp, endTimestamp, NodeType.Cache.value()));
        clusterBrief.setNumOfMQ(this.getMetadataQueryDAO().numOfConjectural(startTimestamp, endTimestamp, NodeType.MQ.value()));
        return clusterBrief;
    }

    public List<Service> getAllServices(long startTimestamp, long endTimestamp) throws IOException {
        return this.getMetadataQueryDAO().getAllServices(startTimestamp, endTimestamp);
    }

    public List<Database> getAllDatabases() throws IOException {
        return this.getMetadataQueryDAO().getAllDatabases();
    }

    public List<Service> searchServices(long startTimestamp, long endTimestamp, String keyword) throws IOException {
        return this.getMetadataQueryDAO().searchServices(startTimestamp, endTimestamp, keyword);
    }

    public List<ServiceInstance> getServiceInstances(long startTimestamp, long endTimestamp, String serviceId) throws IOException {
        return this.getMetadataQueryDAO().getServiceInstances(startTimestamp, endTimestamp, serviceId);
    }

    public List<Endpoint> searchEndpoint(String keyword, String serviceId, int limit) throws IOException {
        return this.getMetadataQueryDAO().searchEndpoint(keyword, serviceId, limit);
    }

    public Service searchService(String serviceCode) throws IOException {
        return this.getMetadataQueryDAO().searchService(serviceCode);
    }

    public EndpointInfo getEndpointInfo(int endpointId) throws IOException {
        EndpointInventory endpointInventory = this.getEndpointInventoryCache().get(endpointId);
        EndpointInfo endpointInfo = new EndpointInfo();
        endpointInfo.setId(endpointInventory.getSequence());
        endpointInfo.setName(endpointInventory.getName());
        endpointInfo.setServiceId(endpointInventory.getServiceId());
        endpointInfo.setServiceName(this.getServiceInventoryCache().get(endpointInventory.getServiceId()).getName());
        return endpointInfo;
    }
}

