/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.entity.LogState;
import org.apache.skywalking.oap.server.core.query.entity.Logs;
import org.apache.skywalking.oap.server.core.query.entity.Pagination;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class LogQueryService
implements Service {
    private final ModuleManager moduleManager;
    private ILogQueryDAO logQueryDAO;
    private ServiceInventoryCache serviceInventoryCache;
    private ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;

    public LogQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private ILogQueryDAO getLogQueryDAO() {
        if (this.logQueryDAO == null) {
            this.logQueryDAO = (ILogQueryDAO)this.moduleManager.find("storage").provider().getService(ILogQueryDAO.class);
        }
        return this.logQueryDAO;
    }

    private ServiceInventoryCache getServiceInventoryCache() {
        if (this.serviceInventoryCache == null) {
            this.serviceInventoryCache = (ServiceInventoryCache)this.moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        }
        return this.serviceInventoryCache;
    }

    private ServiceInstanceInventoryCache getServiceInstanceInventoryCache() {
        if (this.serviceInstanceInventoryCache == null) {
            this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)this.moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        }
        return this.serviceInstanceInventoryCache;
    }

    private EndpointInventoryCache getEndpointInventoryCache() {
        if (this.endpointInventoryCache == null) {
            this.endpointInventoryCache = (EndpointInventoryCache)this.moduleManager.find("core").provider().getService(EndpointInventoryCache.class);
        }
        return this.endpointInventoryCache;
    }

    public Logs queryLogs(String metricName, int serviceId, int serviceInstanceId, int endpointId, String traceId, LogState state, String stateCode, Pagination paging, long startTB, long endTB) throws IOException {
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(paging);
        Logs logs = this.getLogQueryDAO().queryLogs(metricName, serviceId, serviceInstanceId, endpointId, traceId, state, stateCode, paging, page.getFrom(), page.getLimit(), startTB, endTB);
        logs.getLogs().forEach(log -> {
            if (log.getServiceId() != 0) {
                log.setServiceName(this.getServiceInventoryCache().get(log.getServiceId()).getName());
            }
            if (log.getServiceInstanceId() != 0) {
                log.setServiceInstanceName(this.getServiceInstanceInventoryCache().get(log.getServiceInstanceId()).getName());
            }
            if (log.getEndpointId() != 0) {
                log.setEndpointName(this.getEndpointInventoryCache().get(log.getEndpointId()).getName());
            }
        });
        return logs;
    }
}

