/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.query.DurationPoint;
import org.apache.skywalking.oap.server.core.query.entity.Step;
import org.joda.time.DateTime;

public enum DurationUtils {
    INSTANCE;


    public long exchangeToTimeBucket(String dateStr) {
        dateStr = dateStr.replaceAll("-", "");
        dateStr = dateStr.replaceAll(" ", "");
        return Long.valueOf(dateStr);
    }

    public long startTimeDurationToSecondTimeBucket(Step step, String dateStr) {
        long secondTimeBucket = 0L;
        switch (step) {
            case MONTH: {
                secondTimeBucket = this.exchangeToTimeBucket(dateStr) * 100L * 100L * 100L * 100L;
                break;
            }
            case DAY: {
                secondTimeBucket = this.exchangeToTimeBucket(dateStr) * 100L * 100L * 100L;
                break;
            }
            case HOUR: {
                secondTimeBucket = this.exchangeToTimeBucket(dateStr) * 100L * 100L;
                break;
            }
            case MINUTE: {
                secondTimeBucket = this.exchangeToTimeBucket(dateStr) * 100L;
                break;
            }
            case SECOND: {
                secondTimeBucket = this.exchangeToTimeBucket(dateStr);
            }
        }
        return secondTimeBucket;
    }

    public long endTimeDurationToSecondTimeBucket(Step step, String dateStr) {
        long secondTimeBucket = 0L;
        switch (step) {
            case MONTH: {
                secondTimeBucket = (((this.exchangeToTimeBucket(dateStr) * 100L + 99L) * 100L + 99L) * 100L + 99L) * 100L + 99L;
                break;
            }
            case DAY: {
                secondTimeBucket = ((this.exchangeToTimeBucket(dateStr) * 100L + 99L) * 100L + 99L) * 100L + 99L;
                break;
            }
            case HOUR: {
                secondTimeBucket = (this.exchangeToTimeBucket(dateStr) * 100L + 99L) * 100L + 99L;
                break;
            }
            case MINUTE: {
                secondTimeBucket = this.exchangeToTimeBucket(dateStr) * 100L + 99L;
                break;
            }
            case SECOND: {
                secondTimeBucket = this.exchangeToTimeBucket(dateStr);
            }
        }
        return secondTimeBucket;
    }

    public long startTimeToTimestamp(Step step, String dateStr) throws ParseException {
        switch (step) {
            case MONTH: {
                return new SimpleDateFormat("yyyy-MM").parse(dateStr).getTime();
            }
            case DAY: {
                return new SimpleDateFormat("yyyy-MM-dd").parse(dateStr).getTime();
            }
            case HOUR: {
                return new SimpleDateFormat("yyyy-MM-dd HH").parse(dateStr).getTime();
            }
            case MINUTE: {
                return new SimpleDateFormat("yyyy-MM-dd HHmm").parse(dateStr).getTime();
            }
            case SECOND: {
                return new SimpleDateFormat("yyyy-MM-dd HHmmss").parse(dateStr).getTime();
            }
        }
        throw new UnexpectedException("Unsupported step " + step.name());
    }

    public long endTimeToTimestamp(Step step, String dateStr) throws ParseException {
        switch (step) {
            case MONTH: {
                return new DateTime((Object)new SimpleDateFormat("yyyy-MM").parse(dateStr)).plusMonths(1).getMillis();
            }
            case DAY: {
                return new DateTime((Object)new SimpleDateFormat("yyyy-MM-dd").parse(dateStr)).plusDays(1).getMillis();
            }
            case HOUR: {
                return new DateTime((Object)new SimpleDateFormat("yyyy-MM-dd HH").parse(dateStr)).plusHours(1).getMillis();
            }
            case MINUTE: {
                return new DateTime((Object)new SimpleDateFormat("yyyy-MM-dd HHmm").parse(dateStr)).plusMinutes(1).getMillis();
            }
            case SECOND: {
                return new DateTime((Object)new SimpleDateFormat("yyyy-MM-dd HHmmss").parse(dateStr)).plusSeconds(1).getMillis();
            }
        }
        throw new UnexpectedException("Unsupported step " + step.name());
    }

    public int minutesBetween(Downsampling downsampling, DateTime dateTime) {
        switch (downsampling) {
            case Month: {
                return dateTime.dayOfMonth().getMaximumValue() * 24 * 60;
            }
            case Day: {
                return 1440;
            }
            case Hour: {
                return 60;
            }
        }
        return 1;
    }

    public int secondsBetween(Downsampling downsampling, DateTime dateTime) {
        switch (downsampling) {
            case Month: {
                return dateTime.dayOfMonth().getMaximumValue() * 24 * 60 * 60;
            }
            case Day: {
                return 86400;
            }
            case Hour: {
                return 3600;
            }
            case Minute: {
                return 60;
            }
        }
        return 1;
    }

    public List<DurationPoint> getDurationPoints(Downsampling downsampling, long startTimeBucket, long endTimeBucket) throws ParseException {
        DateTime dateTime = this.parseToDateTime(downsampling, startTimeBucket);
        LinkedList<DurationPoint> durations = new LinkedList<DurationPoint>();
        durations.add(new DurationPoint(startTimeBucket, this.secondsBetween(downsampling, dateTime), this.minutesBetween(downsampling, dateTime)));
        int i = 0;
        do {
            switch (downsampling) {
                case Month: {
                    dateTime = dateTime.plusMonths(1);
                    String timeBucket = new SimpleDateFormat("yyyyMM").format(dateTime.toDate());
                    durations.add(new DurationPoint(Long.valueOf(timeBucket), this.secondsBetween(downsampling, dateTime), this.minutesBetween(downsampling, dateTime)));
                    break;
                }
                case Day: {
                    dateTime = dateTime.plusDays(1);
                    String timeBucket = new SimpleDateFormat("yyyyMMdd").format(dateTime.toDate());
                    durations.add(new DurationPoint(Long.valueOf(timeBucket), this.secondsBetween(downsampling, dateTime), this.minutesBetween(downsampling, dateTime)));
                    break;
                }
                case Hour: {
                    dateTime = dateTime.plusHours(1);
                    String timeBucket = new SimpleDateFormat("yyyyMMddHH").format(dateTime.toDate());
                    durations.add(new DurationPoint(Long.valueOf(timeBucket), this.secondsBetween(downsampling, dateTime), this.minutesBetween(downsampling, dateTime)));
                    break;
                }
                case Minute: {
                    dateTime = dateTime.plusMinutes(1);
                    String timeBucket = new SimpleDateFormat("yyyyMMddHHmm").format(dateTime.toDate());
                    durations.add(new DurationPoint(Long.valueOf(timeBucket), this.secondsBetween(downsampling, dateTime), this.minutesBetween(downsampling, dateTime)));
                    break;
                }
                case Second: {
                    dateTime = dateTime.plusSeconds(1);
                    String timeBucket = new SimpleDateFormat("yyyyMMddHHmmss").format(dateTime.toDate());
                    durations.add(new DurationPoint(Long.valueOf(timeBucket), this.secondsBetween(downsampling, dateTime), this.minutesBetween(downsampling, dateTime)));
                }
            }
            if (++i <= 500) continue;
            throw new UnexpectedException("Duration data error, step: " + downsampling.name() + ", start: " + startTimeBucket + ", end: " + endTimeBucket);
        } while (endTimeBucket != ((DurationPoint)durations.get(durations.size() - 1)).getPoint());
        return durations;
    }

    private DateTime parseToDateTime(Downsampling downsampling, long time) throws ParseException {
        DateTime dateTime = null;
        switch (downsampling) {
            case Month: {
                Date date = new SimpleDateFormat("yyyyMM").parse(String.valueOf(time));
                dateTime = new DateTime((Object)date);
                break;
            }
            case Day: {
                Date date = new SimpleDateFormat("yyyyMMdd").parse(String.valueOf(time));
                dateTime = new DateTime((Object)date);
                break;
            }
            case Hour: {
                Date date = new SimpleDateFormat("yyyyMMddHH").parse(String.valueOf(time));
                dateTime = new DateTime((Object)date);
                break;
            }
            case Minute: {
                Date date = new SimpleDateFormat("yyyyMMddHHmm").parse(String.valueOf(time));
                dateTime = new DateTime((Object)date);
                break;
            }
            case Second: {
                Date date = new SimpleDateFormat("yyyyMMddHHmmss").parse(String.valueOf(time));
                dateTime = new DateTime((Object)date);
            }
        }
        return dateTime;
    }
}

