/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNEntity;
import org.apache.skywalking.oap.server.core.register.EndpointInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnIds;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class AggregationQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IAggregationQueryDAO aggregationQueryDAO;

    public AggregationQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IAggregationQueryDAO getAggregationQueryDAO() {
        if (this.aggregationQueryDAO == null) {
            this.aggregationQueryDAO = (IAggregationQueryDAO)this.moduleManager.find("storage").provider().getService(IAggregationQueryDAO.class);
        }
        return this.aggregationQueryDAO;
    }

    public List<TopNEntity> getServiceTopN(String indName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        List<TopNEntity> topNEntities = this.getAggregationQueryDAO().getServiceTopN(indName, ValueColumnIds.INSTANCE.getValueCName(indName), topN, downsampling, startTB, endTB, order);
        for (TopNEntity entity : topNEntities) {
            ServiceInventory inventory = ((ServiceInventoryCache)this.moduleManager.find("core").provider().getService(ServiceInventoryCache.class)).get(Integer.valueOf(entity.getId()));
            if (inventory == null) continue;
            entity.setName(inventory.getName());
        }
        return topNEntities;
    }

    public List<TopNEntity> getAllServiceInstanceTopN(String indName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        List<TopNEntity> topNEntities = this.getAggregationQueryDAO().getAllServiceInstanceTopN(indName, ValueColumnIds.INSTANCE.getValueCName(indName), topN, downsampling, startTB, endTB, order);
        for (TopNEntity entity : topNEntities) {
            ServiceInstanceInventory inventory = ((ServiceInstanceInventoryCache)this.moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class)).get(Integer.valueOf(entity.getId()));
            if (inventory == null) continue;
            entity.setName(inventory.getName());
        }
        return topNEntities;
    }

    public List<TopNEntity> getServiceInstanceTopN(int serviceId, String indName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        List<TopNEntity> topNEntities = this.getAggregationQueryDAO().getServiceInstanceTopN(serviceId, indName, ValueColumnIds.INSTANCE.getValueCName(indName), topN, downsampling, startTB, endTB, order);
        for (TopNEntity entity : topNEntities) {
            ServiceInstanceInventory inventory = ((ServiceInstanceInventoryCache)this.moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class)).get(Integer.valueOf(entity.getId()));
            if (inventory == null) continue;
            entity.setName(inventory.getName());
        }
        return topNEntities;
    }

    public List<TopNEntity> getAllEndpointTopN(String indName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        List<TopNEntity> topNEntities = this.getAggregationQueryDAO().getAllEndpointTopN(indName, ValueColumnIds.INSTANCE.getValueCName(indName), topN, downsampling, startTB, endTB, order);
        for (TopNEntity entity : topNEntities) {
            EndpointInventory inventory = ((EndpointInventoryCache)this.moduleManager.find("core").provider().getService(EndpointInventoryCache.class)).get(Integer.valueOf(entity.getId()));
            if (inventory == null) continue;
            entity.setName(inventory.getName());
        }
        return topNEntities;
    }

    public List<TopNEntity> getEndpointTopN(int serviceId, String indName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        List<TopNEntity> topNEntities = this.getAggregationQueryDAO().getEndpointTopN(serviceId, indName, ValueColumnIds.INSTANCE.getValueCName(indName), topN, downsampling, startTB, endTB, order);
        for (TopNEntity entity : topNEntities) {
            EndpointInventory inventory = ((EndpointInventoryCache)this.moduleManager.find("core").provider().getService(EndpointInventoryCache.class)).get(Integer.valueOf(entity.getId()));
            if (inventory == null) continue;
            entity.setName(inventory.getName());
        }
        return topNEntities;
    }
}

