/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInventoryCache
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInventoryCache.class);
    private final ServiceInventory userService;
    private final Cache<String, Integer> serviceNameCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).build();
    private final Cache<String, Integer> addressIdCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).build();
    private final Cache<Integer, ServiceInventory> serviceIdCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).build();
    private final ModuleManager moduleManager;
    private IServiceInventoryCacheDAO cacheDAO;

    public ServiceInventoryCache(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.userService = new ServiceInventory();
        this.userService.setSequence(1);
        this.userService.setName("User");
        this.userService.setIsAddress(0);
    }

    private IServiceInventoryCacheDAO getCacheDAO() {
        if (Objects.isNull(this.cacheDAO)) {
            this.cacheDAO = (IServiceInventoryCacheDAO)this.moduleManager.find("storage").provider().getService(IServiceInventoryCacheDAO.class);
        }
        return this.cacheDAO;
    }

    public int getServiceId(String serviceName) {
        Integer serviceId = (Integer)this.serviceNameCache.getIfPresent((Object)ServiceInventory.buildId(serviceName));
        if ((Objects.isNull(serviceId) || serviceId == 0) && (serviceId = Integer.valueOf(this.getCacheDAO().getServiceId(serviceName))) != 0) {
            this.serviceNameCache.put((Object)ServiceInventory.buildId(serviceName), (Object)serviceId);
        }
        return serviceId;
    }

    public int getServiceId(int addressId) {
        Integer serviceId = (Integer)this.addressIdCache.getIfPresent((Object)ServiceInventory.buildId(addressId));
        if ((Objects.isNull(serviceId) || serviceId == 0) && (serviceId = Integer.valueOf(this.getCacheDAO().getServiceId(addressId))) != 0) {
            this.addressIdCache.put((Object)ServiceInventory.buildId(addressId), (Object)serviceId);
        }
        return serviceId;
    }

    public ServiceInventory get(int serviceId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Get service by id {} from cache", (Object)serviceId);
        }
        if (1 == serviceId) {
            return this.userService;
        }
        ServiceInventory serviceInventory = (ServiceInventory)this.serviceIdCache.getIfPresent((Object)serviceId);
        if (Objects.isNull(serviceInventory) && Objects.nonNull(serviceInventory = this.getCacheDAO().get(serviceId))) {
            this.serviceIdCache.put((Object)serviceId, (Object)serviceInventory);
        }
        if (logger.isDebugEnabled() && Objects.isNull(serviceInventory)) {
            logger.debug("service id {} not find in cache.", (Object)serviceId);
        }
        return serviceInventory;
    }
}

