/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstanceInventoryCache
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstanceInventoryCache.class);
    private final ServiceInstanceInventory userServiceInstance;
    private final Cache<Integer, ServiceInstanceInventory> serviceInstanceIdCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).build();
    private final Cache<String, Integer> serviceInstanceNameCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).build();
    private final Cache<String, Integer> addressIdCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).build();
    private final ModuleManager moduleManager;
    private IServiceInstanceInventoryCacheDAO cacheDAO;

    public ServiceInstanceInventoryCache(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.userServiceInstance = new ServiceInstanceInventory();
        this.userServiceInstance.setSequence(1);
        this.userServiceInstance.setName("User");
        this.userServiceInstance.setServiceId(1);
        this.userServiceInstance.setIsAddress(0);
    }

    private IServiceInstanceInventoryCacheDAO getCacheDAO() {
        if (Objects.isNull(this.cacheDAO)) {
            this.cacheDAO = (IServiceInstanceInventoryCacheDAO)this.moduleManager.find("storage").provider().getService(IServiceInstanceInventoryCacheDAO.class);
        }
        return this.cacheDAO;
    }

    public ServiceInstanceInventory get(int serviceInstanceId) {
        if (1 == serviceInstanceId) {
            return this.userServiceInstance;
        }
        ServiceInstanceInventory serviceInstanceInventory = (ServiceInstanceInventory)this.serviceInstanceIdCache.getIfPresent((Object)serviceInstanceId);
        if (Objects.isNull(serviceInstanceInventory) && Objects.nonNull(serviceInstanceInventory = this.getCacheDAO().get(serviceInstanceId))) {
            this.serviceInstanceIdCache.put((Object)serviceInstanceId, (Object)serviceInstanceInventory);
        }
        return serviceInstanceInventory;
    }

    public int getServiceInstanceId(int serviceId, String uuid) {
        Integer serviceInstanceId = (Integer)this.serviceInstanceNameCache.getIfPresent((Object)ServiceInstanceInventory.buildId(serviceId, uuid));
        if (Objects.isNull(serviceInstanceId) || serviceInstanceId == 0) {
            serviceInstanceId = this.getCacheDAO().getServiceInstanceId(serviceId, uuid);
            if (serviceId != 0) {
                this.serviceInstanceNameCache.put((Object)ServiceInstanceInventory.buildId(serviceId, uuid), (Object)serviceInstanceId);
            }
        }
        return serviceInstanceId;
    }

    public int getServiceInstanceId(int serviceId, int addressId) {
        Integer serviceInstanceId = (Integer)this.addressIdCache.getIfPresent((Object)ServiceInstanceInventory.buildId(serviceId, addressId));
        if (Objects.isNull(serviceInstanceId) || serviceInstanceId == 0) {
            serviceInstanceId = this.getCacheDAO().getServiceInstanceId(serviceId, addressId);
            if (serviceId != 0) {
                this.addressIdCache.put((Object)ServiceInstanceInventory.buildId(serviceId, addressId), (Object)serviceInstanceId);
            }
        }
        return serviceInstanceId;
    }
}

