/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.register.NetworkAddressInventory;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressInventoryCache
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAddressInventoryCache.class);
    private final Cache<String, Integer> networkAddressCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(5000L).build();
    private final Cache<Integer, NetworkAddressInventory> addressIdCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(5000L).build();
    private final ModuleManager moduleManager;
    private INetworkAddressInventoryCacheDAO cacheDAO;

    public NetworkAddressInventoryCache(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private INetworkAddressInventoryCacheDAO getCacheDAO() {
        if (Objects.isNull(this.cacheDAO)) {
            this.cacheDAO = (INetworkAddressInventoryCacheDAO)this.moduleManager.find("storage").provider().getService(INetworkAddressInventoryCacheDAO.class);
        }
        return this.cacheDAO;
    }

    public int getAddressId(String networkAddress) {
        Integer addressId = (Integer)this.networkAddressCache.getIfPresent((Object)NetworkAddressInventory.buildId(networkAddress));
        if ((Objects.isNull(addressId) || addressId == 0) && (addressId = Integer.valueOf(this.getCacheDAO().getAddressId(networkAddress))) != 0) {
            this.networkAddressCache.put((Object)NetworkAddressInventory.buildId(networkAddress), (Object)addressId);
        }
        return addressId;
    }

    public NetworkAddressInventory get(int addressId) {
        NetworkAddressInventory networkAddress = (NetworkAddressInventory)this.addressIdCache.getIfPresent((Object)addressId);
        if (Objects.isNull(networkAddress) && Objects.nonNull(networkAddress = this.getCacheDAO().get(addressId))) {
            this.addressIdCache.put((Object)addressId, (Object)networkAddress);
        }
        return networkAddress;
    }
}

