/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.register.EndpointInventory;
import org.apache.skywalking.oap.server.core.storage.cache.IEndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointInventoryCache
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(EndpointInventoryCache.class);
    private final ModuleManager moduleManager;
    private final EndpointInventory userEndpoint;
    private final Cache<String, Integer> endpointNameCache = CacheBuilder.newBuilder().initialCapacity(5000).maximumSize(100000L).build();
    private final Cache<Integer, EndpointInventory> endpointIdCache = CacheBuilder.newBuilder().initialCapacity(5000).maximumSize(100000L).build();
    private IEndpointInventoryCacheDAO cacheDAO;

    public EndpointInventoryCache(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.userEndpoint = new EndpointInventory();
        this.userEndpoint.setSequence(1);
        this.userEndpoint.setName("User");
        this.userEndpoint.setServiceId(1);
    }

    private IEndpointInventoryCacheDAO getCacheDAO() {
        if (Objects.isNull(this.cacheDAO)) {
            this.cacheDAO = (IEndpointInventoryCacheDAO)this.moduleManager.find("storage").provider().getService(IEndpointInventoryCacheDAO.class);
        }
        return this.cacheDAO;
    }

    public int getEndpointId(int serviceId, String endpointName, int detectPoint) {
        String id = EndpointInventory.buildId(serviceId, endpointName, detectPoint);
        Integer endpointId = (Integer)this.endpointNameCache.getIfPresent((Object)id);
        if ((Objects.isNull(endpointId) || endpointId == 0) && (endpointId = Integer.valueOf(this.getCacheDAO().getEndpointId(serviceId, endpointName, detectPoint))) != 0) {
            this.endpointNameCache.put((Object)id, (Object)endpointId);
        }
        return endpointId;
    }

    public EndpointInventory get(int endpointId) {
        if (1 == endpointId) {
            return this.userEndpoint;
        }
        EndpointInventory endpointInventory = (EndpointInventory)this.endpointIdCache.getIfPresent((Object)endpointId);
        if (Objects.isNull(endpointInventory)) {
            endpointInventory = this.getCacheDAO().get(endpointId);
            if (Objects.nonNull(endpointInventory)) {
                this.endpointIdCache.put((Object)endpointId, (Object)endpointInventory);
            } else {
                logger.warn("EndpointInventory id {} is not in cache and persistent storage.", (Object)endpointId);
            }
        }
        return endpointInventory;
    }
}

