/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CacheUpdateTimer {
    INSTANCE;

    private static final Logger logger;
    private Boolean isStarted = false;

    public void start(ModuleManager moduleManager) {
        logger.info("Cache update timer start");
        long timeInterval = 3L;
        if (!this.isStarted.booleanValue()) {
            Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(() -> this.update(moduleManager), t -> logger.error("Cache update failure.", t)), 1L, 3L, TimeUnit.SECONDS);
            this.isStarted = true;
        }
    }

    private void update(ModuleManager moduleManager) {
        IServiceInventoryCacheDAO serviceInventoryCacheDAO = (IServiceInventoryCacheDAO)moduleManager.find("storage").provider().getService(IServiceInventoryCacheDAO.class);
        ServiceInventoryCache serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        List<ServiceInventory> serviceInventories = serviceInventoryCacheDAO.loadLastMappingUpdate();
        serviceInventories.forEach(serviceInventory -> {
            logger.info("Update mapping service id in the cache of service inventory, service id: {}, mapping service id: {}", (Object)serviceInventory.getSequence(), (Object)serviceInventory.getMappingServiceId());
            ServiceInventory cache = serviceInventoryCache.get(serviceInventory.getSequence());
            if (Objects.nonNull(cache)) {
                cache.setMappingServiceId(serviceInventory.getMappingServiceId());
                cache.setMappingLastUpdateTime(serviceInventory.getMappingLastUpdateTime());
            } else {
                logger.warn("Unable to found the id of {} in service inventory cache.", (Object)serviceInventory.getSequence());
            }
        });
    }

    static {
        logger = LoggerFactory.getLogger(CacheUpdateTimer.class);
    }
}

