/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.annotation;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.core.annotation.AnnotationListener;

public class AnnotationScan {
    private final List<AnnotationListenerCache> listeners = new LinkedList<AnnotationListenerCache>();

    public void registerListener(AnnotationListener listener) {
        this.listeners.add(new AnnotationListenerCache(listener));
    }

    public void scan(Runnable callBack) throws IOException {
        ClassPath classpath = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Class aClass = classInfo.load();
            for (AnnotationListenerCache listener : this.listeners) {
                if (!aClass.isAnnotationPresent(listener.annotation())) continue;
                listener.addMatch(aClass);
            }
        }
        this.listeners.forEach(rec$ -> ((AnnotationListenerCache)rec$).complete());
        if (callBack != null) {
            callBack.run();
        }
    }

    private class AnnotationListenerCache {
        private AnnotationListener listener;
        private List<Class<?>> matchedClass;

        private AnnotationListenerCache(AnnotationListener listener) {
            this.listener = listener;
            this.matchedClass = new LinkedList();
        }

        private Class<? extends Annotation> annotation() {
            return this.listener.annotation();
        }

        private void addMatch(Class aClass) {
            this.matchedClass.add(aClass);
        }

        private void complete() {
            this.matchedClass.sort(Comparator.comparing(Class::getName));
            this.matchedClass.forEach(aClass -> this.listener.notify((Class)aClass));
        }
    }
}

