/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.core.analysis.data.LimitedSizeDataCache;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNWorker
extends PersistenceWorker<TopN, LimitedSizeDataCache<TopN>> {
    private static final Logger logger = LoggerFactory.getLogger(TopNWorker.class);
    private final LimitedSizeDataCache<TopN> limitedSizeDataCache;
    private final IRecordDAO recordDAO;
    private final Model model;
    private final DataCarrier<TopN> dataCarrier;
    private long reportCycle;
    private volatile long lastReportTimestamp;

    public TopNWorker(ModuleDefineHolder moduleDefineHolder, Model model, int topNSize, IRecordDAO recordDAO) {
        super(moduleDefineHolder, -1);
        this.limitedSizeDataCache = new LimitedSizeDataCache(topNSize);
        this.recordDAO = recordDAO;
        this.model = model;
        this.dataCarrier = new DataCarrier("TopNWorker", 1, 1000);
        this.dataCarrier.consume((IConsumer)new TopNConsumer(), 1);
        this.lastReportTimestamp = System.currentTimeMillis();
        this.reportCycle = 600000L;
    }

    @Override
    void onWork(TopN data) {
        this.limitedSizeDataCache.writing();
        try {
            this.limitedSizeDataCache.add(data);
        }
        finally {
            this.limitedSizeDataCache.finishWriting();
        }
    }

    @Override
    public void cacheData(TopN data) {
    }

    @Override
    public LimitedSizeDataCache<TopN> getCache() {
        return this.limitedSizeDataCache;
    }

    @Override
    public boolean flushAndSwitch() {
        long now = System.currentTimeMillis();
        if (now - this.lastReportTimestamp <= this.reportCycle) {
            return false;
        }
        this.lastReportTimestamp = now;
        return super.flushAndSwitch();
    }

    @Override
    public List<Object> prepareBatch(LimitedSizeDataCache<TopN> cache) {
        LinkedList<Object> batchCollection = new LinkedList<Object>();
        cache.getLast().collection().forEach(record -> {
            try {
                batchCollection.add(this.recordDAO.prepareBatchInsert(this.model, (Record)record));
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
        return batchCollection;
    }

    @Override
    public void in(TopN n) {
        this.dataCarrier.produce((Object)n);
    }

    private class TopNConsumer
    implements IConsumer<TopN> {
        private TopNConsumer() {
        }

        public void init() {
        }

        public void consume(List<TopN> data) {
            data.forEach(row -> TopNWorker.this.onWork((TopN)row));
        }

        public void onError(List<TopN> data, Throwable t) {
            logger.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

