/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DisableRegister;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNWorker;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.IModelSetter;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class TopNStreamProcessor
implements StreamProcessor<TopN> {
    private static final TopNStreamProcessor PROCESSOR = new TopNStreamProcessor();
    private List<TopNWorker> persistentWorkers = new ArrayList<TopNWorker>();
    private Map<Class<? extends Record>, TopNWorker> workers = new HashMap<Class<? extends Record>, TopNWorker>();

    public static TopNStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends TopN> topNClass) {
        IRecordDAO recordDAO;
        if (DisableRegister.INSTANCE.include(stream.name())) {
            return;
        }
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            recordDAO = storageDAO.newRecordDao(stream.builder().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " top n record DAO failure.", e);
        }
        IModelSetter modelSetter = (IModelSetter)moduleDefineHolder.find("core").provider().getService(IModelSetter.class);
        Model model = modelSetter.putIfAbsent(topNClass, stream.scopeId(), new Storage(stream.name(), true, true, Downsampling.Second));
        TopNWorker persistentWorker = new TopNWorker(moduleDefineHolder, model, 50, recordDAO);
        this.persistentWorkers.add(persistentWorker);
        this.workers.put(topNClass, persistentWorker);
    }

    @Override
    public void in(TopN topN) {
        TopNWorker worker = this.workers.get(topN.getClass());
        if (worker != null) {
            worker.in(topN);
        }
    }

    public List<TopNWorker> getPersistentWorkers() {
        return this.persistentWorkers;
    }
}

