/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DisableRegister;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordPersistentWorker;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.IModelSetter;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class RecordStreamProcessor
implements StreamProcessor<Record> {
    private static final RecordStreamProcessor PROCESSOR = new RecordStreamProcessor();
    private Map<Class<? extends Record>, RecordPersistentWorker> workers = new HashMap<Class<? extends Record>, RecordPersistentWorker>();
    private List<RecordPersistentWorker> persistentWorkers = new ArrayList<RecordPersistentWorker>();

    public static RecordStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void in(Record record) {
        RecordPersistentWorker worker = this.workers.get(record.getClass());
        if (worker != null) {
            worker.in(record);
        }
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends Record> recordClass) {
        IRecordDAO recordDAO;
        if (DisableRegister.INSTANCE.include(stream.name())) {
            return;
        }
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            recordDAO = storageDAO.newRecordDao(stream.builder().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " record DAO failure.", e);
        }
        IModelSetter modelSetter = (IModelSetter)moduleDefineHolder.find("core").provider().getService(IModelSetter.class);
        Model model = modelSetter.putIfAbsent(recordClass, stream.scopeId(), new Storage(stream.name(), true, true, Downsampling.Second));
        RecordPersistentWorker persistentWorker = new RecordPersistentWorker(moduleDefineHolder, model, 1000, recordDAO);
        this.persistentWorkers.add(persistentWorker);
        this.workers.put(recordClass, persistentWorker);
    }

    public List<RecordPersistentWorker> getPersistentWorkers() {
        return this.persistentWorkers;
    }
}

