/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.NonMergeDataCache;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordPersistentWorker
extends PersistenceWorker<Record, NonMergeDataCache<Record>> {
    private static final Logger logger = LoggerFactory.getLogger(RecordPersistentWorker.class);
    private final Model model;
    private final NonMergeDataCache<Record> nonMergeDataCache;
    private final IRecordDAO recordDAO;
    private final DataCarrier<Record> dataCarrier;

    RecordPersistentWorker(ModuleDefineHolder moduleDefineHolder, Model model, int batchSize, IRecordDAO recordDAO) {
        super(moduleDefineHolder, batchSize);
        this.model = model;
        this.nonMergeDataCache = new NonMergeDataCache();
        this.recordDAO = recordDAO;
        String name = "RECORD_PERSISTENT";
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, 1, 20L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier = new DataCarrier(1, 10000);
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new PersistentConsumer(this));
    }

    @Override
    public void in(Record record) {
        this.dataCarrier.produce((Object)record);
    }

    @Override
    public NonMergeDataCache<Record> getCache() {
        return this.nonMergeDataCache;
    }

    @Override
    public List<Object> prepareBatch(NonMergeDataCache<Record> cache) {
        LinkedList<Object> batchCollection = new LinkedList<Object>();
        cache.getLast().collection().forEach(record -> {
            try {
                batchCollection.add(this.recordDAO.prepareBatchInsert(this.model, (Record)record));
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
        return batchCollection;
    }

    @Override
    public void cacheData(Record input) {
        this.nonMergeDataCache.writing();
        this.nonMergeDataCache.add(input);
        this.nonMergeDataCache.finishWriting();
    }

    private class PersistentConsumer
    implements IConsumer<Record> {
        private final RecordPersistentWorker persistent;

        private PersistentConsumer(RecordPersistentWorker persistent) {
            this.persistent = persistent;
        }

        public void init() {
        }

        public void consume(List<Record> data) {
            for (Record record : data) {
                this.persistent.onWork(record);
            }
        }

        public void onError(List<Record> data, Throwable t) {
            logger.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

