/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.data.Window;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceWorker<INPUT extends StorageData, CACHE extends Window<INPUT>>
extends AbstractWorker<INPUT> {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceWorker.class);
    private final int batchSize;
    private final IBatchDAO batchDAO;

    PersistenceWorker(ModuleDefineHolder moduleDefineHolder, int batchSize) {
        super(moduleDefineHolder);
        this.batchSize = batchSize;
        this.batchDAO = (IBatchDAO)moduleDefineHolder.find("storage").provider().getService(IBatchDAO.class);
    }

    void onWork(INPUT input) {
        if (((Window)this.getCache()).currentCollectionSize() >= this.batchSize) {
            try {
                if (((Window)this.getCache()).trySwitchPointer()) {
                    ((Window)this.getCache()).switchPointer();
                    List<?> collection = this.buildBatchCollection();
                    this.batchDAO.batchPersistence(collection);
                }
            }
            finally {
                ((Window)this.getCache()).trySwitchPointerFinally();
            }
        }
        this.cacheData(input);
    }

    public abstract void cacheData(INPUT var1);

    public abstract CACHE getCache();

    public boolean flushAndSwitch() {
        boolean isSwitch;
        try {
            isSwitch = ((Window)this.getCache()).trySwitchPointer();
            if (isSwitch) {
                ((Window)this.getCache()).switchPointer();
            }
        }
        finally {
            ((Window)this.getCache()).trySwitchPointerFinally();
        }
        return isSwitch;
    }

    public abstract List<Object> prepareBatch(CACHE var1);

    public final List<?> buildBatchCollection() {
        List<Object> batchCollection = new LinkedList();
        try {
            while (((Window)this.getCache()).getLast().isWriting()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.warn("thread wake up");
                }
            }
            if (((Window)this.getCache()).getLast().collection() != null) {
                batchCollection = this.prepareBatch(this.getCache());
            }
        }
        finally {
            ((Window)this.getCache()).finishReadingLast();
        }
        return batchCollection;
    }
}

