/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.Objects;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsPersistentWorker;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsTransWorker
extends AbstractWorker<Metrics> {
    private static final Logger logger = LoggerFactory.getLogger(MetricsTransWorker.class);
    private final MetricsPersistentWorker minutePersistenceWorker;
    private final MetricsPersistentWorker hourPersistenceWorker;
    private final MetricsPersistentWorker dayPersistenceWorker;
    private final MetricsPersistentWorker monthPersistenceWorker;
    private CounterMetrics aggregationMinCounter;
    private CounterMetrics aggregationHourCounter;
    private CounterMetrics aggregationDayCounter;
    private CounterMetrics aggregationMonthCounter;

    public MetricsTransWorker(ModuleDefineHolder moduleDefineHolder, String modelName, MetricsPersistentWorker minutePersistenceWorker, MetricsPersistentWorker hourPersistenceWorker, MetricsPersistentWorker dayPersistenceWorker, MetricsPersistentWorker monthPersistenceWorker) {
        super(moduleDefineHolder);
        this.minutePersistenceWorker = minutePersistenceWorker;
        this.hourPersistenceWorker = hourPersistenceWorker;
        this.dayPersistenceWorker = dayPersistenceWorker;
        this.monthPersistenceWorker = monthPersistenceWorker;
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        this.aggregationMinCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "2", "min"}));
        this.aggregationHourCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "2", "hour"}));
        this.aggregationDayCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "2", "day"}));
        this.aggregationMonthCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "2", "month"}));
    }

    @Override
    public void in(Metrics metrics) {
        if (Objects.nonNull(this.hourPersistenceWorker)) {
            this.aggregationMonthCounter.inc();
            this.hourPersistenceWorker.in(metrics.toHour());
        }
        if (Objects.nonNull(this.dayPersistenceWorker)) {
            this.aggregationDayCounter.inc();
            this.dayPersistenceWorker.in(metrics.toDay());
        }
        if (Objects.nonNull(this.monthPersistenceWorker)) {
            this.aggregationHourCounter.inc();
            this.monthPersistenceWorker.in(metrics.toMonth());
        }
        if (Objects.nonNull(this.minutePersistenceWorker)) {
            this.aggregationMinCounter.inc();
            this.minutePersistenceWorker.in(metrics);
        }
    }
}

