/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DisableRegister;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.AlarmNotifyWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.ExportWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsAggregateWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsPersistentWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsRemoteWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsTransWorker;
import org.apache.skywalking.oap.server.core.config.DownsamplingConfigService;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingSetter;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.IModelSetter;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class MetricsStreamProcessor
implements StreamProcessor<Metrics> {
    private static final MetricsStreamProcessor PROCESSOR = new MetricsStreamProcessor();
    private Map<Class<? extends Metrics>, MetricsAggregateWorker> entryWorkers = new HashMap<Class<? extends Metrics>, MetricsAggregateWorker>();
    private List<MetricsPersistentWorker> persistentWorkers = new ArrayList<MetricsPersistentWorker>();

    public static MetricsStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void in(Metrics metrics) {
        MetricsAggregateWorker worker = this.entryWorkers.get(metrics.getClass());
        if (worker != null) {
            worker.in(metrics);
        }
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends Metrics> metricsClass) {
        Model model;
        IMetricsDAO metricsDAO;
        if (DisableRegister.INSTANCE.include(stream.name())) {
            return;
        }
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            metricsDAO = storageDAO.newMetricsDao(stream.builder().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " metrics DAO failure.", e);
        }
        IModelSetter modelSetter = (IModelSetter)moduleDefineHolder.find("core").provider().getService(IModelSetter.class);
        DownsamplingConfigService configService = (DownsamplingConfigService)moduleDefineHolder.find("core").provider().getService(DownsamplingConfigService.class);
        StreamDataMappingSetter streamDataMappingSetter = (StreamDataMappingSetter)moduleDefineHolder.find("core").provider().getService(StreamDataMappingSetter.class);
        streamDataMappingSetter.putIfAbsent(metricsClass);
        MetricsPersistentWorker hourPersistentWorker = null;
        MetricsPersistentWorker dayPersistentWorker = null;
        MetricsPersistentWorker monthPersistentWorker = null;
        if (configService.shouldToHour()) {
            model = modelSetter.putIfAbsent(metricsClass, stream.scopeId(), new Storage(stream.name(), true, true, Downsampling.Hour));
            hourPersistentWorker = this.worker(moduleDefineHolder, metricsDAO, model);
        }
        if (configService.shouldToDay()) {
            model = modelSetter.putIfAbsent(metricsClass, stream.scopeId(), new Storage(stream.name(), true, true, Downsampling.Day));
            dayPersistentWorker = this.worker(moduleDefineHolder, metricsDAO, model);
        }
        if (configService.shouldToMonth()) {
            model = modelSetter.putIfAbsent(metricsClass, stream.scopeId(), new Storage(stream.name(), true, true, Downsampling.Month));
            monthPersistentWorker = this.worker(moduleDefineHolder, metricsDAO, model);
        }
        model = modelSetter.putIfAbsent(metricsClass, stream.scopeId(), new Storage(stream.name(), true, true, Downsampling.Minute));
        MetricsPersistentWorker minutePersistentWorker = this.minutePersistentWorker(moduleDefineHolder, metricsDAO, model);
        MetricsTransWorker transWorker = new MetricsTransWorker(moduleDefineHolder, stream.name(), minutePersistentWorker, hourPersistentWorker, dayPersistentWorker, monthPersistentWorker);
        MetricsRemoteWorker remoteWorker = new MetricsRemoteWorker(moduleDefineHolder, transWorker, stream.name());
        MetricsAggregateWorker aggregateWorker = new MetricsAggregateWorker(moduleDefineHolder, remoteWorker, stream.name());
        this.entryWorkers.put(metricsClass, aggregateWorker);
    }

    private MetricsPersistentWorker minutePersistentWorker(ModuleDefineHolder moduleDefineHolder, IMetricsDAO metricsDAO, Model model) {
        AlarmNotifyWorker alarmNotifyWorker = new AlarmNotifyWorker(moduleDefineHolder);
        ExportWorker exportWorker = new ExportWorker(moduleDefineHolder);
        MetricsPersistentWorker minutePersistentWorker = new MetricsPersistentWorker(moduleDefineHolder, model, 1000, metricsDAO, alarmNotifyWorker, exportWorker);
        this.persistentWorkers.add(minutePersistentWorker);
        return minutePersistentWorker;
    }

    private MetricsPersistentWorker worker(ModuleDefineHolder moduleDefineHolder, IMetricsDAO metricsDAO, Model model) {
        MetricsPersistentWorker persistentWorker = new MetricsPersistentWorker(moduleDefineHolder, model, 1000, metricsDAO, null, null);
        this.persistentWorkers.add(persistentWorker);
        return persistentWorker;
    }

    public List<MetricsPersistentWorker> getPersistentWorkers() {
        return this.persistentWorkers;
    }
}

