/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.RemoteSenderService;
import org.apache.skywalking.oap.server.core.remote.selector.Selector;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsRemoteWorker
extends AbstractWorker<Metrics> {
    private static final Logger logger = LoggerFactory.getLogger(MetricsRemoteWorker.class);
    private final AbstractWorker<Metrics> nextWorker;
    private final RemoteSenderService remoteSender;
    private final String modelName;

    MetricsRemoteWorker(ModuleDefineHolder moduleDefineHolder, AbstractWorker<Metrics> nextWorker, String modelName) {
        super(moduleDefineHolder);
        this.remoteSender = (RemoteSenderService)moduleDefineHolder.find("core").provider().getService(RemoteSenderService.class);
        this.nextWorker = nextWorker;
        this.modelName = modelName;
    }

    @Override
    public final void in(Metrics metrics) {
        try {
            this.remoteSender.send(this.nextWorker.getWorkerId(), metrics, Selector.HashCode);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

