/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.EndOfBatchContext;
import org.apache.skywalking.oap.server.core.analysis.data.MergeDataCache;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.exporter.ExportEvent;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsPersistentWorker
extends PersistenceWorker<Metrics, MergeDataCache<Metrics>> {
    private static final Logger logger = LoggerFactory.getLogger(MetricsPersistentWorker.class);
    private final Model model;
    private final MergeDataCache<Metrics> mergeDataCache;
    private final IMetricsDAO metricsDAO;
    private final AbstractWorker<Metrics> nextAlarmWorker;
    private final AbstractWorker<ExportEvent> nextExportWorker;
    private final DataCarrier<Metrics> dataCarrier;

    MetricsPersistentWorker(ModuleDefineHolder moduleDefineHolder, Model model, int batchSize, IMetricsDAO metricsDAO, AbstractWorker<Metrics> nextAlarmWorker, AbstractWorker<ExportEvent> nextExportWorker) {
        super(moduleDefineHolder, batchSize);
        this.model = model;
        this.mergeDataCache = new MergeDataCache();
        this.metricsDAO = metricsDAO;
        this.nextAlarmWorker = nextAlarmWorker;
        this.nextExportWorker = nextExportWorker;
        String name = "METRICS_L2_AGGREGATION";
        int size = BulkConsumePool.Creator.recommendMaxSize() / 8;
        if (size == 0) {
            size = 1;
        }
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, size, 20L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier = new DataCarrier("MetricsPersistentWorker." + model.getName(), name, 1, 2000);
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new PersistentConsumer(this));
    }

    @Override
    void onWork(Metrics metrics) {
        super.onWork(metrics);
    }

    @Override
    public void in(Metrics metrics) {
        metrics.setEndOfBatchContext(new EndOfBatchContext(false));
        this.dataCarrier.produce((Object)metrics);
    }

    @Override
    public MergeDataCache<Metrics> getCache() {
        return this.mergeDataCache;
    }

    @Override
    public boolean flushAndSwitch() {
        boolean isSwitch;
        try {
            isSwitch = this.getCache().trySwitchPointer();
            if (isSwitch) {
                this.getCache().switchPointer();
            }
        }
        finally {
            this.getCache().trySwitchPointerFinally();
        }
        return isSwitch;
    }

    @Override
    public List<Object> prepareBatch(MergeDataCache<Metrics> cache) {
        LinkedList<Object> batchCollection = new LinkedList<Object>();
        cache.getLast().collection().forEach(data -> {
            if (Objects.nonNull(this.nextExportWorker)) {
                ExportEvent event = new ExportEvent((Metrics)data, ExportEvent.EventType.INCREMENT);
                this.nextExportWorker.in(event);
            }
            Metrics dbData = null;
            try {
                dbData = this.metricsDAO.get(this.model, (Metrics)data);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
            try {
                if (Objects.nonNull(dbData)) {
                    data.combine(dbData);
                    data.calculate();
                    batchCollection.add(this.metricsDAO.prepareBatchUpdate(this.model, (Metrics)data));
                } else {
                    batchCollection.add(this.metricsDAO.prepareBatchInsert(this.model, (Metrics)data));
                }
                if (Objects.nonNull(this.nextAlarmWorker)) {
                    this.nextAlarmWorker.in((Metrics)data);
                }
                if (Objects.nonNull(this.nextExportWorker)) {
                    ExportEvent event = new ExportEvent((Metrics)data, ExportEvent.EventType.TOTAL);
                    this.nextExportWorker.in(event);
                }
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        });
        return batchCollection;
    }

    @Override
    public void cacheData(Metrics input) {
        this.mergeDataCache.writing();
        if (this.mergeDataCache.containsKey(input)) {
            Metrics metrics = this.mergeDataCache.get(input);
            metrics.combine(input);
            metrics.calculate();
        } else {
            input.calculate();
            this.mergeDataCache.put(input);
        }
        this.mergeDataCache.finishWriting();
    }

    private class PersistentConsumer
    implements IConsumer<Metrics> {
        private final MetricsPersistentWorker persistent;

        private PersistentConsumer(MetricsPersistentWorker persistent) {
            this.persistent = persistent;
        }

        public void init() {
        }

        public void consume(List<Metrics> data) {
            Iterator<Metrics> inputIterator = data.iterator();
            int i = 0;
            while (inputIterator.hasNext()) {
                Metrics metrics = inputIterator.next();
                if (++i == data.size()) {
                    metrics.getEndOfBatchContext().setEndOfBatch(true);
                }
                this.persistent.onWork(metrics);
            }
        }

        public void onError(List<Metrics> data, Throwable t) {
            logger.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

