/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.EnvUtil;
import org.apache.skywalking.apm.commons.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.EndOfBatchContext;
import org.apache.skywalking.oap.server.core.analysis.data.MergeDataCache;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAggregateWorker
extends AbstractWorker<Metrics> {
    private static final Logger logger = LoggerFactory.getLogger(MetricsAggregateWorker.class);
    private AbstractWorker<Metrics> nextWorker;
    private final DataCarrier<Metrics> dataCarrier;
    private final MergeDataCache<Metrics> mergeDataCache;
    private final String modelName;
    private CounterMetrics aggregationCounter;
    private final long l2AggregationSendCycle;
    private long lastSendTimestamp;

    MetricsAggregateWorker(ModuleDefineHolder moduleDefineHolder, AbstractWorker<Metrics> nextWorker, String modelName) {
        super(moduleDefineHolder);
        this.modelName = modelName;
        this.nextWorker = nextWorker;
        this.mergeDataCache = new MergeDataCache();
        String name = "METRICS_L1_AGGREGATION";
        this.dataCarrier = new DataCarrier("MetricsAggregateWorker." + modelName, name, 2, 10000);
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, BulkConsumePool.Creator.recommendMaxSize() * 2, 20L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new AggregatorConsumer(this));
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        this.aggregationCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "1", "min"}));
        this.lastSendTimestamp = System.currentTimeMillis();
        this.l2AggregationSendCycle = EnvUtil.getLong((String)"METRICS_L1_AGGREGATION_SEND_CYCLE", (long)1000L);
    }

    @Override
    public final void in(Metrics metrics) {
        metrics.setEndOfBatchContext(new EndOfBatchContext(false));
        this.dataCarrier.produce((Object)metrics);
    }

    private void onWork(Metrics metrics) {
        this.aggregationCounter.inc();
        this.aggregate(metrics);
        if (metrics.getEndOfBatchContext().isEndOfBatch() && this.shouldSend()) {
            this.sendToNext();
        }
    }

    private boolean shouldSend() {
        long now = System.currentTimeMillis();
        if (now - this.lastSendTimestamp > this.l2AggregationSendCycle) {
            this.lastSendTimestamp = now;
            return true;
        }
        return false;
    }

    private void sendToNext() {
        this.mergeDataCache.switchPointer();
        while (this.mergeDataCache.getLast().isWriting()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.mergeDataCache.getLast().collection().forEach(data -> {
            if (logger.isDebugEnabled()) {
                logger.debug(data.toString());
            }
            this.nextWorker.in((Metrics)data);
        });
        this.mergeDataCache.finishReadingLast();
    }

    private void aggregate(Metrics metrics) {
        this.mergeDataCache.writing();
        if (this.mergeDataCache.containsKey(metrics)) {
            this.mergeDataCache.get(metrics).combine(metrics);
        } else {
            this.mergeDataCache.put(metrics);
        }
        this.mergeDataCache.finishWriting();
    }

    private class AggregatorConsumer
    implements IConsumer<Metrics> {
        private final MetricsAggregateWorker aggregator;

        private AggregatorConsumer(MetricsAggregateWorker aggregator) {
            this.aggregator = aggregator;
        }

        public void init() {
        }

        public void consume(List<Metrics> data) {
            Iterator<Metrics> inputIterator = data.iterator();
            int i = 0;
            while (inputIterator.hasNext()) {
                Metrics metrics = inputIterator.next();
                if (++i == data.size()) {
                    metrics.getEndOfBatchContext().setEndOfBatch(true);
                }
                this.aggregator.onWork(metrics);
            }
        }

        public void onError(List<Metrics> data, Throwable t) {
            logger.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

