/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueArray;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="thermodynamic")
public abstract class ThermodynamicMetrics
extends Metrics {
    public static final String DETAIL_GROUP = "detail_group";
    public static final String STEP = "step";
    public static final String NUM_OF_STEPS = "num_of_steps";
    @Column(columnName="step")
    private int step = 0;
    @Column(columnName="num_of_steps")
    private int numOfSteps = 0;
    @Column(columnName="detail_group", isValue=true)
    private IntKeyLongValueArray detailGroup = new IntKeyLongValueArray(30);
    private Map<Integer, IntKeyLongValue> detailIndex;

    @Entrance
    public final void combine(@SourceFrom int value, @Arg int step, @Arg int maxNumOfSteps) {
        IntKeyLongValue element;
        if (this.step == 0) {
            this.step = step;
        }
        if (this.numOfSteps == 0) {
            this.numOfSteps = maxNumOfSteps;
        }
        this.indexCheckAndInit();
        int index = value / step;
        if (index > maxNumOfSteps) {
            index = this.numOfSteps;
        }
        if ((element = this.detailIndex.get(index)) == null) {
            element = new IntKeyLongValue();
            element.setKey(index);
            element.setValue(1L);
            this.addElement(element);
        } else {
            element.addValue(1L);
        }
    }

    @Override
    public void combine(Metrics metrics) {
        ThermodynamicMetrics thermodynamicMetrics = (ThermodynamicMetrics)metrics;
        this.indexCheckAndInit();
        thermodynamicMetrics.indexCheckAndInit();
        ThermodynamicMetrics self = this;
        thermodynamicMetrics.detailIndex.forEach((key, element) -> {
            IntKeyLongValue existingElement = self.detailIndex.get(key);
            if (existingElement == null) {
                existingElement = new IntKeyLongValue();
                existingElement.setKey((int)key);
                existingElement.setValue(element.getValue());
                self.addElement((IntKeyLongValue)element);
            } else {
                existingElement.addValue(element.getValue());
            }
        });
    }

    @Override
    public final void calculate() {
    }

    private void addElement(IntKeyLongValue element) {
        this.detailGroup.add(element);
        this.detailIndex.put(element.getKey(), element);
    }

    private void indexCheckAndInit() {
        if (this.detailIndex == null) {
            this.detailIndex = new HashMap<Integer, IntKeyLongValue>();
            this.detailGroup.forEach(element -> this.detailIndex.put(element.getKey(), (IntKeyLongValue)element));
        }
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getNumOfSteps() {
        return this.numOfSteps;
    }

    public void setNumOfSteps(int numOfSteps) {
        this.numOfSteps = numOfSteps;
    }

    public IntKeyLongValueArray getDetailGroup() {
        return this.detailGroup;
    }

    public void setDetailGroup(IntKeyLongValueArray detailGroup) {
        this.detailGroup = detailGroup;
    }
}

