/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueArray;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

public abstract class PxxMetrics
extends Metrics
implements IntValueHolder {
    protected static final String DETAIL_GROUP = "detail_group";
    protected static final String VALUE = "value";
    protected static final String PRECISION = "precision";
    @Column(columnName="value", isValue=true, function=Function.Avg)
    private int value;
    @Column(columnName="precision")
    private int precision;
    @Column(columnName="detail_group")
    private IntKeyLongValueArray detailGroup;
    private final int percentileRank;
    private Map<Integer, IntKeyLongValue> detailIndex;

    public PxxMetrics(int percentileRank) {
        this.percentileRank = percentileRank;
        this.detailGroup = new IntKeyLongValueArray(30);
    }

    @Entrance
    public final void combine(@SourceFrom int value, @Arg int precision) {
        this.precision = precision;
        this.indexCheckAndInit();
        int index = value / precision;
        IntKeyLongValue element = this.detailIndex.get(index);
        if (element == null) {
            element = new IntKeyLongValue();
            element.setKey(index);
            element.setValue(1L);
            this.addElement(element);
        } else {
            element.addValue(1L);
        }
    }

    @Override
    public void combine(Metrics metrics) {
        PxxMetrics pxxMetrics = (PxxMetrics)metrics;
        this.indexCheckAndInit();
        pxxMetrics.indexCheckAndInit();
        pxxMetrics.detailIndex.forEach((key, element) -> {
            IntKeyLongValue existingElement = this.detailIndex.get(key);
            if (existingElement == null) {
                existingElement = new IntKeyLongValue();
                existingElement.setKey((int)key);
                existingElement.setValue(element.getValue());
                this.addElement((IntKeyLongValue)element);
            } else {
                existingElement.addValue(element.getValue());
            }
        });
    }

    @Override
    public final void calculate() {
        Collections.sort(this.detailGroup);
        int total = this.detailGroup.stream().mapToInt(element -> (int)element.getValue()).sum();
        int roof = Math.round((float)(total * this.percentileRank) * 1.0f / 100.0f);
        int count = 0;
        for (IntKeyLongValue element2 : this.detailGroup) {
            if ((count = (int)((long)count + element2.getValue())) < roof) continue;
            this.value = element2.getKey() * this.precision;
            return;
        }
    }

    private void addElement(IntKeyLongValue element) {
        this.detailGroup.add(element);
        this.detailIndex.put(element.getKey(), element);
    }

    private void indexCheckAndInit() {
        if (this.detailIndex == null) {
            this.detailIndex = new HashMap<Integer, IntKeyLongValue>();
            this.detailGroup.forEach(element -> this.detailIndex.put(element.getKey(), (IntKeyLongValue)element));
        }
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public IntKeyLongValueArray getDetailGroup() {
        return this.detailGroup;
    }

    public void setDetailGroup(IntKeyLongValueArray detailGroup) {
        this.detailGroup = detailGroup;
    }
}

