/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Expression;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ExpressionArg0;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ExpressionArg1;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="percent")
public abstract class PercentMetrics
extends Metrics
implements IntValueHolder {
    protected static final String TOTAL = "total";
    protected static final String MATCH = "match";
    protected static final String PERCENTAGE = "percentage";
    @Column(columnName="total")
    private long total;
    @Column(columnName="percentage", isValue=true, function=Function.Avg)
    private int percentage;
    @Column(columnName="match")
    private long match;

    @Entrance
    public final void combine(@Expression EqualMatch expression, @ExpressionArg0 Object leftValue, @ExpressionArg1 Object rightValue) {
        expression.setLeft(leftValue);
        expression.setRight(rightValue);
        if (expression.match()) {
            ++this.match;
        }
        ++this.total;
    }

    @Override
    public final void combine(Metrics metrics) {
        this.total += ((PercentMetrics)metrics).total;
        this.match += ((PercentMetrics)metrics).match;
    }

    @Override
    public void calculate() {
        this.percentage = (int)(this.match * 10000L / this.total);
    }

    @Override
    public int getValue() {
        return this.percentage;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int percentage) {
        this.percentage = percentage;
    }

    public long getMatch() {
        return this.match;
    }

    public void setMatch(long match) {
        this.match = match;
    }
}

