/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class Metrics
extends StreamData
implements StorageData {
    private static DateTimeFormatter TIME_BUCKET_MONTH_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMM");
    public static final String TIME_BUCKET = "time_bucket";
    public static final String ENTITY_ID = "entity_id";
    @Column(columnName="time_bucket")
    private long timeBucket;

    @Override
    public abstract String id();

    public abstract void combine(Metrics var1);

    public abstract void calculate();

    public abstract Metrics toHour();

    public abstract Metrics toDay();

    public abstract Metrics toMonth();

    public long toTimeBucketInHour() {
        if (this.isMinuteBucket()) {
            return this.timeBucket / 100L;
        }
        throw new IllegalStateException("Current time bucket is not in minute dimensionality");
    }

    public long toTimeBucketInDay() {
        if (this.isMinuteBucket()) {
            return this.timeBucket / 10000L;
        }
        if (this.isHourBucket()) {
            return this.timeBucket / 100L;
        }
        throw new IllegalStateException("Current time bucket is not in minute dimensionality");
    }

    public long toTimeBucketInMonth() {
        if (this.isMinuteBucket()) {
            return this.timeBucket / 1000000L;
        }
        if (this.isHourBucket()) {
            return this.timeBucket / 10000L;
        }
        if (this.isDayBucket()) {
            return this.timeBucket / 100L;
        }
        throw new IllegalStateException("Current time bucket is not in minute dimensionality");
    }

    protected long getDurationInMinute() {
        if (this.isMinuteBucket()) {
            return 1L;
        }
        if (this.isHourBucket()) {
            return 60L;
        }
        if (this.isDayBucket()) {
            return 1440L;
        }
        int dayOfMonth = TIME_BUCKET_MONTH_FORMATTER.parseLocalDate(this.timeBucket + "").getDayOfMonth();
        return dayOfMonth * 24 * 60;
    }

    private boolean isMinuteBucket() {
        return this.timeBucket < 999999999999L && this.timeBucket > 100000000000L;
    }

    private boolean isHourBucket() {
        return this.timeBucket < 9999999999L && this.timeBucket > 1000000000L;
    }

    private boolean isDayBucket() {
        return this.timeBucket < 99999999L && this.timeBucket > 10000000L;
    }

    public long getTimeBucket() {
        return this.timeBucket;
    }

    public void setTimeBucket(long timeBucket) {
        this.timeBucket = timeBucket;
    }
}

