/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="longAvg")
public abstract class LongAvgMetrics
extends Metrics
implements LongValueHolder {
    protected static final String SUMMATION = "summation";
    protected static final String COUNT = "count";
    protected static final String VALUE = "value";
    @Column(columnName="summation")
    private long summation;
    @Column(columnName="count")
    private int count;
    @Column(columnName="value", isValue=true, function=Function.Avg)
    private long value;

    @Entrance
    public final void combine(@SourceFrom long summation, @ConstOne int count) {
        this.summation += summation;
        this.count += count;
    }

    @Override
    public final void combine(Metrics metrics) {
        LongAvgMetrics longAvgMetrics = (LongAvgMetrics)metrics;
        this.combine(longAvgMetrics.summation, longAvgMetrics.count);
    }

    @Override
    public final void calculate() {
        this.value = this.summation / (long)this.count;
    }

    public long getSummation() {
        return this.summation;
    }

    public void setSummation(long summation) {
        this.summation = summation;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }
}

