/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.Objects;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.IntKeyLongValuePair;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataType;

public class IntKeyLongValue
implements Comparable<IntKeyLongValue>,
StorageDataType {
    private int key;
    private long value;

    public IntKeyLongValue() {
    }

    public IntKeyLongValue(int key, long value) {
        this.key = key;
        this.value = value;
    }

    public void addValue(long value) {
        this.value += value;
    }

    @Override
    public int compareTo(IntKeyLongValue o) {
        return this.key - o.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntKeyLongValue value = (IntKeyLongValue)o;
        return this.key == value.key;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public IntKeyLongValuePair serialize() {
        return IntKeyLongValuePair.newBuilder().setKey(this.key).setValue(this.value).build();
    }

    public void deserialize(IntKeyLongValuePair pair) {
        this.key = pair.getKey();
        this.value = pair.getValue();
    }

    @Override
    public String toStorageData() {
        return this.key + "," + this.value;
    }

    @Override
    public void toObject(String data) {
        String[] keyValue = data.split(",");
        this.key = Integer.valueOf(keyValue[0]);
        this.value = Long.valueOf(keyValue[1]);
    }

    @Override
    public void copyFrom(Object source) {
        IntKeyLongValue value = (IntKeyLongValue)source;
        this.key = value.key;
        this.value = value.value;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public int getKey() {
        return this.key;
    }

    public long getValue() {
        return this.value;
    }
}

