/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="doubleAvg")
public abstract class DoubleAvgMetrics
extends Metrics
implements DoubleValueHolder {
    protected static final String SUMMATION = "summation";
    protected static final String COUNT = "count";
    protected static final String VALUE = "value";
    @Column(columnName="summation")
    private double summation;
    @Column(columnName="count")
    private int count;
    @Column(columnName="value", isValue=true, function=Function.Avg)
    private double value;

    @Entrance
    public final void combine(@SourceFrom double summation, @ConstOne int count) {
        this.summation += summation;
        this.count += count;
    }

    @Override
    public final void combine(Metrics metrics) {
        DoubleAvgMetrics doubleAvgMetrics = (DoubleAvgMetrics)metrics;
        this.combine(doubleAvgMetrics.summation, doubleAvgMetrics.count);
    }

    @Override
    public final void calculate() {
        this.value = this.summation / (double)this.count;
    }

    public double getSummation() {
        return this.summation;
    }

    public void setSummation(double summation) {
        this.summation = summation;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }
}

