/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="cpm")
public abstract class CPMMetrics
extends Metrics
implements LongValueHolder {
    protected static final String VALUE = "value";
    protected static final String TOTAL = "total";
    @Column(columnName="value", isValue=true, function=Function.Avg)
    private long value;
    @Column(columnName="total")
    private long total;

    @Entrance
    public final void combine(@ConstOne long count) {
        this.total += count;
    }

    @Override
    public final void combine(Metrics metrics) {
        CPMMetrics cpmMetrics = (CPMMetrics)metrics;
        this.combine(cpmMetrics.total);
    }

    @Override
    public void calculate() {
        this.value = this.total / this.getDurationInMinute();
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }
}

