/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.servicerelation;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.manual.RelationDefineUtil;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="service_relation_server_side", scopeId=4, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class ServiceRelationServerSideMetrics
extends Metrics {
    public static final String INDEX_NAME = "service_relation_server_side";
    public static final String SOURCE_SERVICE_ID = "source_service_id";
    public static final String DEST_SERVICE_ID = "dest_service_id";
    public static final String COMPONENT_ID = "component_id";
    @Column(columnName="source_service_id")
    @IDColumn
    private int sourceServiceId;
    @Column(columnName="dest_service_id")
    @IDColumn
    private int destServiceId;
    @Column(columnName="component_id")
    @IDColumn
    private int componentId;
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;

    @Override
    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + RelationDefineUtil.buildEntityId(new RelationDefineUtil.RelationDefine(this.sourceServiceId, this.destServiceId, this.componentId));
        return splitJointId;
    }

    public void buildEntityId() {
        String splitJointId = String.valueOf(this.sourceServiceId);
        splitJointId = splitJointId + "_" + String.valueOf(this.destServiceId);
        this.entityId = splitJointId = splitJointId + "_" + String.valueOf(this.componentId);
    }

    @Override
    public void combine(Metrics metrics) {
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        ServiceRelationServerSideMetrics metrics = new ServiceRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setSourceServiceId(this.getSourceServiceId());
        metrics.setDestServiceId(this.getDestServiceId());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        ServiceRelationServerSideMetrics metrics = new ServiceRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setSourceServiceId(this.getSourceServiceId());
        metrics.setDestServiceId(this.getDestServiceId());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public Metrics toMonth() {
        ServiceRelationServerSideMetrics metrics = new ServiceRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        metrics.setSourceServiceId(this.getSourceServiceId());
        metrics.setDestServiceId(this.getDestServiceId());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.sourceServiceId;
        result = 31 * result + this.destServiceId;
        result = 31 * result + this.componentId;
        return result;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSourceServiceId(remoteData.getDataIntegers(0));
        this.setDestServiceId(remoteData.getDataIntegers(1));
        this.setComponentId(remoteData.getDataIntegers(2));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataIntegers(this.getSourceServiceId());
        remoteBuilder.addDataIntegers(this.getDestServiceId());
        remoteBuilder.addDataIntegers(this.getComponentId());
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        return remoteBuilder;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.sourceServiceId;
        result = 31 * result + this.destServiceId;
        result = 31 * result + this.componentId;
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceRelationServerSideMetrics metrics = (ServiceRelationServerSideMetrics)obj;
        if (this.sourceServiceId != metrics.sourceServiceId) {
            return false;
        }
        if (this.destServiceId != metrics.destServiceId) {
            return false;
        }
        if (this.componentId != metrics.componentId) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public void setSourceServiceId(int sourceServiceId) {
        this.sourceServiceId = sourceServiceId;
    }

    public int getSourceServiceId() {
        return this.sourceServiceId;
    }

    public void setDestServiceId(int destServiceId) {
        this.destServiceId = destServiceId;
    }

    public int getDestServiceId() {
        return this.destServiceId;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    public int getComponentId() {
        return this.componentId;
    }

    private void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public static class Builder
    implements StorageBuilder<ServiceRelationServerSideMetrics> {
        @Override
        public ServiceRelationServerSideMetrics map2Data(Map<String, Object> dbMap) {
            ServiceRelationServerSideMetrics metrics = new ServiceRelationServerSideMetrics();
            metrics.setEntityId((String)dbMap.get("entity_id"));
            metrics.setSourceServiceId(((Number)dbMap.get(ServiceRelationServerSideMetrics.SOURCE_SERVICE_ID)).intValue());
            metrics.setDestServiceId(((Number)dbMap.get(ServiceRelationServerSideMetrics.DEST_SERVICE_ID)).intValue());
            metrics.setComponentId(((Number)dbMap.get(ServiceRelationServerSideMetrics.COMPONENT_ID)).intValue());
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }

        @Override
        public Map<String, Object> data2Map(ServiceRelationServerSideMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity_id", storageData.getEntityId());
            map.put(ServiceRelationServerSideMetrics.SOURCE_SERVICE_ID, storageData.getSourceServiceId());
            map.put(ServiceRelationServerSideMetrics.DEST_SERVICE_ID, storageData.getDestServiceId());
            map.put(ServiceRelationServerSideMetrics.COMPONENT_ID, storageData.getComponentId());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }
    }
}

