/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.servicerelation;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.manual.servicerelation.ServiceRelationClientSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.servicerelation.ServiceRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ServiceRelation;

public class ServiceCallRelationDispatcher
implements SourceDispatcher<ServiceRelation> {
    @Override
    public void dispatch(ServiceRelation source) {
        switch (source.getDetectPoint()) {
            case SERVER: {
                this.serverSide(source);
                break;
            }
            case CLIENT: {
                this.clientSide(source);
            }
        }
    }

    private void serverSide(ServiceRelation source) {
        ServiceRelationServerSideMetrics metrics = new ServiceRelationServerSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setDestServiceId(source.getDestServiceId());
        metrics.setComponentId(source.getComponentId());
        metrics.buildEntityId();
        MetricsStreamProcessor.getInstance().in(metrics);
    }

    private void clientSide(ServiceRelation source) {
        ServiceRelationClientSideMetrics metrics = new ServiceRelationClientSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setDestServiceId(source.getDestServiceId());
        metrics.setComponentId(source.getComponentId());
        metrics.buildEntityId();
        MetricsStreamProcessor.getInstance().in(metrics);
    }
}

