/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.segment;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

@Stream(name="segment", scopeId=12, builder=Builder.class, processor=RecordStreamProcessor.class)
public class SegmentRecord
extends Record {
    public static final String INDEX_NAME = "segment";
    public static final String SEGMENT_ID = "segment_id";
    public static final String TRACE_ID = "trace_id";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ENDPOINT_NAME = "endpoint_name";
    public static final String ENDPOINT_ID = "endpoint_id";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String LATENCY = "latency";
    public static final String IS_ERROR = "is_error";
    public static final String DATA_BINARY = "data_binary";
    public static final String VERSION = "version";
    @Column(columnName="segment_id")
    private String segmentId;
    @Column(columnName="trace_id")
    private String traceId;
    @Column(columnName="service_id")
    private int serviceId;
    @Column(columnName="service_instance_id")
    private int serviceInstanceId;
    @Column(columnName="endpoint_name", matchQuery=true)
    private String endpointName;
    @Column(columnName="endpoint_id")
    private int endpointId;
    @Column(columnName="start_time")
    private long startTime;
    @Column(columnName="end_time")
    private long endTime;
    @Column(columnName="latency")
    private int latency;
    @Column(columnName="is_error")
    private int isError;
    @Column(columnName="data_binary")
    private byte[] dataBinary;
    @Column(columnName="version")
    private int version;

    @Override
    public String id() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceInstanceId(int serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    public int getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointId(int endpointId) {
        this.endpointId = endpointId;
    }

    public int getEndpointId() {
        return this.endpointId;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setIsError(int isError) {
        this.isError = isError;
    }

    public int getIsError() {
        return this.isError;
    }

    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder
    implements StorageBuilder<SegmentRecord> {
        @Override
        public Map<String, Object> data2Map(SegmentRecord storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(SegmentRecord.SEGMENT_ID, storageData.getSegmentId());
            map.put(SegmentRecord.TRACE_ID, storageData.getTraceId());
            map.put(SegmentRecord.SERVICE_ID, storageData.getServiceId());
            map.put(SegmentRecord.SERVICE_INSTANCE_ID, storageData.getServiceInstanceId());
            map.put(SegmentRecord.ENDPOINT_NAME, storageData.getEndpointName());
            map.put(SegmentRecord.ENDPOINT_ID, storageData.getEndpointId());
            map.put(SegmentRecord.START_TIME, storageData.getStartTime());
            map.put(SegmentRecord.END_TIME, storageData.getEndTime());
            map.put(SegmentRecord.LATENCY, storageData.getLatency());
            map.put(SegmentRecord.IS_ERROR, storageData.getIsError());
            map.put("time_bucket", storageData.getTimeBucket());
            if (CollectionUtils.isEmpty((byte[])storageData.getDataBinary())) {
                map.put(SegmentRecord.DATA_BINARY, "");
            } else {
                map.put(SegmentRecord.DATA_BINARY, new String(Base64.getEncoder().encode(storageData.getDataBinary())));
            }
            map.put(SegmentRecord.VERSION, storageData.getVersion());
            return map;
        }

        @Override
        public SegmentRecord map2Data(Map<String, Object> dbMap) {
            SegmentRecord record = new SegmentRecord();
            record.setSegmentId((String)dbMap.get(SegmentRecord.SEGMENT_ID));
            record.setTraceId((String)dbMap.get(SegmentRecord.TRACE_ID));
            record.setServiceId(((Number)dbMap.get(SegmentRecord.SERVICE_ID)).intValue());
            record.setServiceInstanceId(((Number)dbMap.get(SegmentRecord.SERVICE_INSTANCE_ID)).intValue());
            record.setEndpointName((String)dbMap.get(SegmentRecord.ENDPOINT_NAME));
            record.setEndpointId(((Number)dbMap.get(SegmentRecord.ENDPOINT_ID)).intValue());
            record.setStartTime(((Number)dbMap.get(SegmentRecord.START_TIME)).longValue());
            record.setEndTime(((Number)dbMap.get(SegmentRecord.END_TIME)).longValue());
            record.setLatency(((Number)dbMap.get(SegmentRecord.LATENCY)).intValue());
            record.setIsError(((Number)dbMap.get(SegmentRecord.IS_ERROR)).intValue());
            record.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            if (StringUtil.isEmpty((String)((String)dbMap.get(SegmentRecord.DATA_BINARY)))) {
                record.setDataBinary(new byte[0]);
            } else {
                record.setDataBinary(Base64.getDecoder().decode((String)dbMap.get(SegmentRecord.DATA_BINARY)));
            }
            record.setVersion(((Number)dbMap.get(SegmentRecord.VERSION)).intValue());
            return record;
        }
    }
}

