/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.query.entity.ContentType;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

public abstract class AbstractLogRecord
extends Record {
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ENDPOINT_ID = "endpoint_id";
    public static final String TRACE_ID = "trace_id";
    public static final String IS_ERROR = "is_error";
    public static final String STATUS_CODE = "status_code";
    public static final String CONTENT_TYPE = "content_type";
    public static final String CONTENT = "content";
    public static final String TIMESTAMP = "timestamp";
    @Column(columnName="service_id")
    private int serviceId;
    @Column(columnName="service_instance_id")
    private int serviceInstanceId;
    @Column(columnName="endpoint_id")
    private int endpointId;
    @Column(columnName="trace_id")
    private String traceId;
    @Column(columnName="is_error")
    private int isError;
    @Column(columnName="status_code")
    private String statusCode;
    @Column(columnName="content_type")
    private int contentType = ContentType.NONE.value();
    @Column(columnName="content")
    private String content;
    @Column(columnName="timestamp")
    private long timestamp;

    @Override
    public String id() {
        throw new UnexpectedException("AbstractLogRecord doesn't provide id()");
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceInstanceId(int serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    public int getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public void setEndpointId(int endpointId) {
        this.endpointId = endpointId;
    }

    public int getEndpointId() {
        return this.endpointId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setIsError(int isError) {
        this.isError = isError;
    }

    public int getIsError() {
        return this.isError;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setContentType(int contentType) {
        this.contentType = contentType;
    }

    public int getContentType() {
        return this.contentType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static abstract class Builder<T extends AbstractLogRecord>
    implements StorageBuilder<T> {
        protected void map2Data(T record, Map<String, Object> dbMap) {
            ((AbstractLogRecord)record).setServiceId(((Number)dbMap.get(AbstractLogRecord.SERVICE_ID)).intValue());
            ((AbstractLogRecord)record).setServiceInstanceId(((Number)dbMap.get(AbstractLogRecord.SERVICE_INSTANCE_ID)).intValue());
            ((AbstractLogRecord)record).setEndpointId(((Number)dbMap.get(AbstractLogRecord.ENDPOINT_ID)).intValue());
            ((AbstractLogRecord)record).setIsError(((Number)dbMap.get(AbstractLogRecord.IS_ERROR)).intValue());
            ((AbstractLogRecord)record).setTraceId((String)dbMap.get(AbstractLogRecord.TRACE_ID));
            ((AbstractLogRecord)record).setStatusCode((String)dbMap.get(AbstractLogRecord.STATUS_CODE));
            ((AbstractLogRecord)record).setContentType(((Number)dbMap.get(AbstractLogRecord.CONTENT_TYPE)).intValue());
            ((AbstractLogRecord)record).setContent((String)dbMap.get(AbstractLogRecord.CONTENT));
            ((AbstractLogRecord)record).setTimestamp(((Number)dbMap.get(AbstractLogRecord.TIMESTAMP)).longValue());
            ((Record)record).setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
        }

        @Override
        public Map<String, Object> data2Map(AbstractLogRecord record) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(AbstractLogRecord.SERVICE_ID, record.getServiceId());
            map.put(AbstractLogRecord.SERVICE_INSTANCE_ID, record.getServiceInstanceId());
            map.put(AbstractLogRecord.ENDPOINT_ID, record.getEndpointId());
            map.put(AbstractLogRecord.TRACE_ID, record.getTraceId());
            map.put(AbstractLogRecord.IS_ERROR, record.getIsError());
            map.put(AbstractLogRecord.STATUS_CODE, record.getStatusCode());
            map.put("time_bucket", record.getTimeBucket());
            map.put(AbstractLogRecord.CONTENT_TYPE, record.getContentType());
            map.put(AbstractLogRecord.CONTENT, record.getContent());
            map.put(AbstractLogRecord.TIMESTAMP, record.getTimestamp());
            return map;
        }
    }
}

