/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.endpointrelation;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="endpoint_relation_server_side", scopeId=6, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class EndpointRelationServerSideMetrics
extends Metrics {
    public static final String INDEX_NAME = "endpoint_relation_server_side";
    public static final String SOURCE_ENDPOINT_ID = "source_endpoint_id";
    public static final String DEST_ENDPOINT_ID = "dest_endpoint_id";
    public static final String COMPONENT_ID = "component_id";
    @Column(columnName="source_endpoint_id")
    @IDColumn
    private int sourceEndpointId;
    @Column(columnName="dest_endpoint_id")
    @IDColumn
    private int destEndpointId;
    @Column(columnName="component_id")
    @IDColumn
    private int componentId;
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;

    @Override
    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.sourceEndpointId;
        splitJointId = splitJointId + "_" + this.destEndpointId;
        splitJointId = splitJointId + "_" + this.componentId;
        return splitJointId;
    }

    public void buildEntityId() {
        String splitJointId = String.valueOf(this.sourceEndpointId);
        splitJointId = splitJointId + "_" + String.valueOf(this.destEndpointId);
        this.entityId = splitJointId = splitJointId + "_" + String.valueOf(this.componentId);
    }

    @Override
    public void combine(Metrics metrics) {
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setSourceEndpointId(this.getSourceEndpointId());
        metrics.setDestEndpointId(this.getDestEndpointId());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setSourceEndpointId(this.getSourceEndpointId());
        metrics.setDestEndpointId(this.getDestEndpointId());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public Metrics toMonth() {
        EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        metrics.setSourceEndpointId(this.getSourceEndpointId());
        metrics.setDestEndpointId(this.getDestEndpointId());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.sourceEndpointId;
        result = 31 * result + this.destEndpointId;
        result = 31 * result + this.componentId;
        return result;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setSourceEndpointId(remoteData.getDataIntegers(0));
        this.setDestEndpointId(remoteData.getDataIntegers(1));
        this.setComponentId(remoteData.getDataIntegers(2));
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataIntegers(this.getSourceEndpointId());
        remoteBuilder.addDataIntegers(this.getDestEndpointId());
        remoteBuilder.addDataIntegers(this.getComponentId());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.getEntityId());
        return remoteBuilder;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.sourceEndpointId;
        result = 31 * result + this.destEndpointId;
        result = 31 * result + this.componentId;
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointRelationServerSideMetrics metrics = (EndpointRelationServerSideMetrics)obj;
        if (this.sourceEndpointId != metrics.sourceEndpointId) {
            return false;
        }
        if (this.destEndpointId != metrics.destEndpointId) {
            return false;
        }
        if (this.componentId != metrics.componentId) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public void setSourceEndpointId(int sourceEndpointId) {
        this.sourceEndpointId = sourceEndpointId;
    }

    public int getSourceEndpointId() {
        return this.sourceEndpointId;
    }

    public void setDestEndpointId(int destEndpointId) {
        this.destEndpointId = destEndpointId;
    }

    public int getDestEndpointId() {
        return this.destEndpointId;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    public int getComponentId() {
        return this.componentId;
    }

    private void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public static class Builder
    implements StorageBuilder<EndpointRelationServerSideMetrics> {
        @Override
        public EndpointRelationServerSideMetrics map2Data(Map<String, Object> dbMap) {
            EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
            metrics.setSourceEndpointId(((Number)dbMap.get(EndpointRelationServerSideMetrics.SOURCE_ENDPOINT_ID)).intValue());
            metrics.setDestEndpointId(((Number)dbMap.get(EndpointRelationServerSideMetrics.DEST_ENDPOINT_ID)).intValue());
            metrics.setComponentId(((Number)dbMap.get(EndpointRelationServerSideMetrics.COMPONENT_ID)).intValue());
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            metrics.setEntityId((String)dbMap.get("entity_id"));
            return metrics;
        }

        @Override
        public Map<String, Object> data2Map(EndpointRelationServerSideMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(EndpointRelationServerSideMetrics.SOURCE_ENDPOINT_ID, storageData.getSourceEndpointId());
            map.put(EndpointRelationServerSideMetrics.DEST_ENDPOINT_ID, storageData.getDestEndpointId());
            map.put(EndpointRelationServerSideMetrics.COMPONENT_ID, storageData.getComponentId());
            map.put("time_bucket", storageData.getTimeBucket());
            map.put("entity_id", storageData.getEntityId());
            return map;
        }
    }
}

