/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;

@Stream(name="top_n_database_statement", scopeId=18, builder=Builder.class, processor=TopNStreamProcessor.class)
public class TopNDatabaseStatement
extends TopN {
    public static final String INDEX_NAME = "top_n_database_statement";
    private String id;

    @Override
    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNDatabaseStatement statement = (TopNDatabaseStatement)o;
        return this.getServiceId() == statement.getServiceId();
    }

    public int hashCode() {
        return Objects.hash(this.getServiceId());
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class Builder
    implements StorageBuilder<TopNDatabaseStatement> {
        @Override
        public TopNDatabaseStatement map2Data(Map<String, Object> dbMap) {
            TopNDatabaseStatement statement = new TopNDatabaseStatement();
            statement.setStatement((String)dbMap.get("statement"));
            statement.setTraceId((String)dbMap.get("trace_id"));
            statement.setLatency(((Number)dbMap.get("latency")).longValue());
            statement.setServiceId(((Number)dbMap.get("service_id")).intValue());
            statement.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return statement;
        }

        @Override
        public Map<String, Object> data2Map(TopNDatabaseStatement storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("statement", storageData.getStatement());
            map.put("trace_id", storageData.getTraceId());
            map.put("latency", storageData.getLatency());
            map.put("service_id", storageData.getServiceId());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }
    }
}

