/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual;

public class RelationDefineUtil {
    public static String buildEntityId(RelationDefine define) {
        return String.valueOf(define.source) + "_" + String.valueOf(define.dest) + "_" + String.valueOf(define.componentId);
    }

    public static RelationDefine splitEntityId(String entityId) {
        String[] parts = entityId.split("_");
        if (parts.length != 3) {
            throw new RuntimeException("Illegal Service/Endpoint Relation entity id");
        }
        return new RelationDefine(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    public static class RelationDefine {
        private int source;
        private int dest;
        private int componentId;

        public RelationDefine(int source, int dest, int componentId) {
            this.source = source;
            this.dest = dest;
            this.componentId = componentId;
        }

        public int getSource() {
            return this.source;
        }

        public int getDest() {
            return this.dest;
        }

        public int getComponentId() {
            return this.componentId;
        }
    }
}

