/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.data;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.oap.server.core.analysis.data.SWCollection;

public abstract class Window<DATA> {
    private AtomicInteger windowSwitch = new AtomicInteger(0);
    private SWCollection<DATA> pointer;
    private SWCollection<DATA> windowDataA;
    private SWCollection<DATA> windowDataB;

    Window() {
        this(true);
    }

    Window(boolean autoInit) {
        if (autoInit) {
            this.init();
        }
    }

    protected void init() {
        this.windowDataA = this.collectionInstance();
        this.windowDataB = this.collectionInstance();
        this.pointer = this.windowDataA;
    }

    public abstract SWCollection<DATA> collectionInstance();

    public boolean trySwitchPointer() {
        return this.windowSwitch.incrementAndGet() == 1 && !this.getLast().isReading();
    }

    public void trySwitchPointerFinally() {
        this.windowSwitch.addAndGet(-1);
    }

    public void switchPointer() {
        this.pointer = this.pointer == this.windowDataA ? this.windowDataB : this.windowDataA;
        this.getLast().reading();
    }

    SWCollection<DATA> getCurrentAndWriting() {
        if (this.pointer == this.windowDataA) {
            this.windowDataA.writing();
            return this.windowDataA;
        }
        this.windowDataB.writing();
        return this.windowDataB;
    }

    private SWCollection<DATA> getCurrent() {
        return this.pointer;
    }

    public int currentCollectionSize() {
        return this.getCurrent().size();
    }

    public SWCollection<DATA> getLast() {
        if (this.pointer == this.windowDataA) {
            return this.windowDataB;
        }
        return this.windowDataA;
    }

    public void finishReadingLast() {
        this.getLast().clear();
        this.getLast().finishReading();
    }
}

