/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.data.SWCollection;
import org.apache.skywalking.oap.server.core.storage.StorageData;

public class NonMergeDataCollection<STORAGE_DATA extends StorageData>
implements SWCollection<STORAGE_DATA> {
    private final List<STORAGE_DATA> data = new ArrayList<STORAGE_DATA>();
    private volatile boolean writing = false;
    private volatile boolean reading = false;

    NonMergeDataCollection() {
    }

    @Override
    public void finishWriting() {
        this.writing = false;
    }

    @Override
    public void writing() {
        this.writing = true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    @Override
    public void finishReading() {
        this.reading = false;
    }

    @Override
    public void reading() {
        this.reading = true;
    }

    @Override
    public boolean isReading() {
        return this.reading;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean containsKey(STORAGE_DATA key) {
        throw new UnsupportedOperationException("Non merge data collection doesn't support containsKey operation.");
    }

    @Override
    public STORAGE_DATA get(STORAGE_DATA key) {
        throw new UnsupportedOperationException("Non merge data collection doesn't support get operation.");
    }

    @Override
    public void put(STORAGE_DATA value) {
        this.data.add(value);
    }

    @Override
    public Collection<STORAGE_DATA> collection() {
        return this.data;
    }
}

