/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.skywalking.oap.server.core.analysis.data.SWCollection;
import org.apache.skywalking.oap.server.core.storage.ComparableStorageData;

public class LimitedSizeDataCollection<STORAGE_DATA extends ComparableStorageData>
implements SWCollection<STORAGE_DATA> {
    private final HashMap<STORAGE_DATA, LinkedList<STORAGE_DATA>> data = new HashMap();
    private final int limitedSize;
    private volatile boolean writing = false;
    private volatile boolean reading = false;

    LimitedSizeDataCollection(int limitedSize) {
        this.limitedSize = limitedSize;
    }

    @Override
    public void finishWriting() {
        this.writing = false;
    }

    @Override
    public void writing() {
        this.writing = true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    @Override
    public void finishReading() {
        this.reading = false;
    }

    @Override
    public void reading() {
        this.reading = true;
    }

    @Override
    public boolean isReading() {
        return this.reading;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean containsKey(STORAGE_DATA key) {
        throw new UnsupportedOperationException("Limited size data collection doesn't support containsKey operation.");
    }

    @Override
    public STORAGE_DATA get(STORAGE_DATA key) {
        throw new UnsupportedOperationException("Limited size data collection doesn't support get operation.");
    }

    @Override
    public void put(STORAGE_DATA value) {
        LinkedList<Object> storageDataList = this.data.get(value);
        if (storageDataList == null) {
            storageDataList = new LinkedList();
            this.data.put(value, storageDataList);
        }
        if (storageDataList.size() < this.limitedSize) {
            storageDataList.add(value);
            return;
        }
        for (int i = 0; i < storageDataList.size(); ++i) {
            ComparableStorageData storageData = (ComparableStorageData)storageDataList.get(i);
            if (value.compareTo((ComparableStorageData)storageData) > 0) continue;
            if (i != 0) {
                storageDataList.add(i, value);
                storageDataList.removeFirst();
            }
            return;
        }
        storageDataList.addLast(value);
        storageDataList.removeFirst();
    }

    @Override
    public Collection<STORAGE_DATA> collection() {
        ArrayList collection = new ArrayList();
        this.data.values().forEach(e -> e.forEach(collection::add));
        return collection;
    }
}

