/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.data;

import org.apache.skywalking.oap.server.core.analysis.data.DataCache;
import org.apache.skywalking.oap.server.core.analysis.data.LimitedSizeDataCollection;
import org.apache.skywalking.oap.server.core.analysis.data.SWCollection;
import org.apache.skywalking.oap.server.core.analysis.data.Window;
import org.apache.skywalking.oap.server.core.storage.ComparableStorageData;

public class LimitedSizeDataCache<STORAGE_DATA extends ComparableStorageData>
extends Window<STORAGE_DATA>
implements DataCache {
    private SWCollection<STORAGE_DATA> limitedSizeDataCollection;
    private final int limitSize;

    public LimitedSizeDataCache(int limitSize) {
        super(false);
        this.limitSize = limitSize;
        this.init();
    }

    @Override
    public SWCollection<STORAGE_DATA> collectionInstance() {
        return new LimitedSizeDataCollection(this.limitSize);
    }

    public void add(STORAGE_DATA data) {
        this.limitedSizeDataCollection.put(data);
    }

    @Override
    public void writing() {
        this.limitedSizeDataCollection = this.getCurrentAndWriting();
    }

    @Override
    public void finishWriting() {
        this.limitedSizeDataCollection.finishWriting();
        this.limitedSizeDataCollection = null;
    }
}

