/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import java.util.Calendar;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;

public class TimeBucket {
    public static long getSecondTimeBucket(long time) {
        return TimeBucket.getTimeBucket(time, Downsampling.Second);
    }

    public static long getMinuteTimeBucket(long time) {
        return TimeBucket.getTimeBucket(time, Downsampling.Minute);
    }

    public static long getTimeBucket(long time, Downsampling downsampling) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        long year = calendar.get(1);
        long month = calendar.get(2) + 1;
        long day = calendar.get(5);
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        switch (downsampling) {
            case Second: {
                return year * 10000000000L + month * 100000000L + day * 1000000L + hour * 10000L + minute * 100L + second;
            }
            case Minute: {
                return year * 100000000L + month * 1000000L + day * 10000L + hour * 100L + minute;
            }
            case Hour: {
                return year * 1000000L + month * 10000L + day * 100L + hour;
            }
            case Day: {
                return year * 10000L + month * 100L + day;
            }
            case Month: {
                return year * 100L + month;
            }
        }
        throw new UnexpectedException("Unknown downsampling value.");
    }
}

